/*
 * Decompiled with CFR 0.152.
 */
package syl.movement.gravity;

import syl.core.BaseRobot;
import syl.movement.GravityMovementStrategy;
import syl.movement.gravity.GravityMovementFeature;
import syl.movement.gravity.GravityPoint;
import syl.util.Coordinate;

public class RepellantCorner
extends GravityMovementFeature {
    private static final String CORNER_POINT = "cornerPoint";
    private static final double CORNER_POWER = -3000.0;
    private static final double CORNER_RANGE = 2.0;
    private GravityMovementStrategy strategy;
    private long invalidTime;

    public RepellantCorner(BaseRobot robot, GravityMovementStrategy strategy) {
        this.strategy = strategy;
        strategy.addFeature(this);
    }

    public void updateGravityPoints(BaseRobot robot) {
        if (robot.isCornerNear()) {
            double lowestDistance = Double.MAX_VALUE;
            Coordinate closestCorner = null;
            if (robot.getCoordinate().getDistance(Coordinate.LOWER_LEFT) < lowestDistance) {
                closestCorner = Coordinate.LOWER_LEFT;
                lowestDistance = robot.getCoordinate().getDistance(Coordinate.LOWER_LEFT);
            }
            if (robot.getCoordinate().getDistance(Coordinate.UPPER_LEFT) < lowestDistance) {
                closestCorner = Coordinate.UPPER_LEFT;
                lowestDistance = robot.getCoordinate().getDistance(Coordinate.UPPER_LEFT);
            }
            if (robot.getCoordinate().getDistance(Coordinate.LOWER_RIGHT) < lowestDistance) {
                closestCorner = Coordinate.LOWER_RIGHT;
                lowestDistance = robot.getCoordinate().getDistance(Coordinate.LOWER_RIGHT);
            }
            if (robot.getCoordinate().getDistance(Coordinate.UPPER_RIGHT) < lowestDistance) {
                closestCorner = Coordinate.UPPER_RIGHT;
                lowestDistance = robot.getCoordinate().getDistance(Coordinate.UPPER_RIGHT);
            }
            GravityPoint gravPoint = new GravityPoint(closestCorner, -3000.0, 2.0);
            this.invalidTime = robot.getTime() + 25L;
            this.strategy.putGravityPoint(CORNER_POINT, gravPoint);
        } else if (robot.getTime() >= this.invalidTime) {
            this.strategy.removeGravityPoint(CORNER_POINT);
        }
    }
}

