/*
 * Decompiled with CFR 0.152.
 */
package rtk;

import java.awt.geom.Point2D;
import rtk.Tachikoma;

public class Help {
    public static Point2D calcPos(Point2D o, double dir, double dis) {
        Point2D.Double pos = new Point2D.Double();
        pos.x = o.getX() + Help.calcFromDirX(dir, dis);
        pos.y = o.getY() + Help.calcFromDirY(dir, dis);
        return pos;
    }

    public static double calcFromDirX(double dir, double dis) {
        double theta = Math.toRadians(dir);
        return Math.sin(theta) * dis;
    }

    public static double calcFromDirY(double dir, double dis) {
        double theta = Math.toRadians(dir);
        return Math.cos(theta) * dis;
    }

    public static double calcDirection(Point2D a, Point2D b) {
        return (Math.toDegrees(Math.atan2(b.getX() - a.getX(), b.getY() - a.getY())) + 360.0) % 360.0;
    }

    public static double calcDiagonal(double w, double h) {
        return Math.pow(Math.pow(w, 2.0) + Math.pow(h, 2.0), 0.5);
    }

    public static double calcAngleDiff(double a, double b) {
        double d = b - a;
        while (d < -180.0) {
            d += 360.0;
        }
        while (d > 180.0) {
            d -= 360.0;
        }
        return d;
    }

    public static double calcDirectionForMoving(Point2D origin1, Point2D origin2, double speed1, double speed2, double dir2) {
        double alpha = speed2 / speed1;
        double dir = Help.calcDirection(origin1, origin2);
        double phi = Math.toRadians(dir2 - dir);
        double beta = alpha * Math.sin(phi);
        dir = Math.abs(beta) >= 1.0 ? -1.0 : (dir += Math.toDegrees(Math.asin(beta)));
        return dir;
    }

    public static double calcWallAheadDis(Point2D pos, double velocity, double heading, boolean ignoreStopped) {
        double edge;
        if (ignoreStopped && velocity == 0.0) {
            return Double.MAX_VALUE;
        }
        double x1 = pos.getX();
        double y1 = pos.getY();
        double dir = velocity >= 0.0 ? heading : (heading + 180.0) % 360.0;
        Point2D p2 = Help.calcPos(pos, dir, Tachikoma.FIELD_SIZE_MAX);
        double x2 = p2.getX();
        double y2 = p2.getY();
        double dx = x2 - x1;
        double dy = y2 - y1;
        double tx = 0.0;
        double ty = 0.0;
        if (dx != 0.0) {
            edge = 0.0;
            if (dx > 0.0) {
                edge = Tachikoma.FIELD_WIDTH;
            }
            tx = (edge - x1) / dx;
        }
        if (dy != 0.0) {
            edge = 0.0;
            if (dy > 0.0) {
                edge = Tachikoma.FIELD_HEIGHT;
            }
            ty = (edge - y1) / dy;
        }
        double t = dx == 0.0 && dy == 0.0 ? 0.0 : (dx == 0.0 ? ty : (dy == 0.0 ? tx : Math.min(tx, ty)));
        double ax = x1 + dx * t;
        double ay = y1 + dy * t;
        double dis = pos.distance(new Point2D.Double(ax, ay));
        return dis;
    }

    public static double calcClosestWallDis(Point2D pos) {
        double x = Math.min(pos.getX(), (double)Tachikoma.FIELD_WIDTH - pos.getX());
        double y = Math.min(pos.getY(), (double)Tachikoma.FIELD_HEIGHT - pos.getY());
        return Math.min(x, y);
    }
}

