/*
 * Decompiled with CFR 0.152.
 */
package bndl;

import bandol.misc.Fncts;
import bndl.CoolSpotNavigator;
import bndl.Enemy;
import bndl.EnemyTable;
import bndl.Gun;
import bndl.Scan;
import java.awt.Color;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RadarTurnCompleteCondition;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.TurnCompleteCondition;
import robocode.WinEvent;

public class LostLion
extends AdvancedRobot {
    EnemyTable enemies;
    CoolSpotNavigator navigator;
    Gun gun;
    int scanCW;
    int direction;
    boolean gameOver;
    int skippedTurns;
    int wallCollisions;
    int robotCollisions;

    public void init() {
        this.enemies = new EnemyTable(this);
        this.navigator = new CoolSpotNavigator(this);
        this.gun = new Gun(this);
        this.scanCW = 1;
        this.direction = 1;
        this.gameOver = false;
        this.robotCollisions = 0;
        this.wallCollisions = 0;
        this.skippedTurns = 0;
        this.setColors(Color.orange, Color.red, Color.yellow);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.addCustomEvent((Condition)new RadarTurnCompleteCondition((AdvancedRobot)this));
    }

    public void run() {
        double d = 0.0;
        this.init();
        this.setTurnRadarLeftRadians(Math.PI * 2);
        while (true) {
            if (!this.gameOver) {
                double d2 = this.navigator.getNextDirection(this.enemies);
                this.setTurnRightRadiansOptimal(Fncts.normRelRadians(d2 - this.getHeadingRadians()));
                this.setAhead(this.navigator.getMovement());
                this.navigator.addBotState();
                if (this.getGunTurnRemainingRadians() == 0.0) {
                    if (this.getGunHeat() == 0.0 && this.enemies.getLastTarget() != null && this.gun.getBulletPower() != 0.0) {
                        Bullet bullet = this.setFireBullet(this.gun.getBulletPower());
                        this.enemies.getLastTarget().onFire(bullet);
                    } else {
                        d = this.gun.aimAt(this.enemies.getNextTarget(this.getTime()));
                        this.setTurnGunRightRadians(d);
                    }
                }
            }
            this.execute();
        }
    }

    public void doScan() {
        double d = 0.0;
        double d2 = 0.0;
        Vector vector = this.enemies.getUpdatedEnemyKeysVec(this.getTime());
        int n = vector.size();
        Enumeration enumeration = vector.elements();
        double[] dArray = new double[n];
        Arrays.fill(dArray, 0.0);
        if (!enumeration.hasMoreElements() || this.enemies.getAliveEnemyKeysVec().size() != n) {
            d2 = Math.PI * 2;
        } else {
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                Enemy enemy = (Enemy)this.enemies.get(enumeration.nextElement());
                dArray[n2] = Fncts.normAbsRadians(enemy.getDirection(this.getX(), this.getY()));
                ++n2;
            }
            Arrays.sort(dArray);
            n2 = 0;
            while (n2 < n) {
                if (Fncts.normAbsRadians(dArray[(n2 + 1) % n] - dArray[n2]) >= d) {
                    d = Fncts.normAbsRadians(dArray[(n2 + 1) % n] - dArray[n2]);
                    d2 = this.scanCW == 1 ? Fncts.normAbsRadians(dArray[n2] - this.getRadarHeadingRadians()) + 0.3 : -Fncts.normAbsRadians(this.getRadarHeadingRadians() - dArray[(n2 + 1) % n]) - 0.3;
                }
                ++n2;
            }
        }
        this.setTurnRadarRightRadians(d2);
        this.scanCW = -this.scanCW;
    }

    public void onCustomEvent(CustomEvent customEvent) {
        if (customEvent.getCondition() instanceof RadarTurnCompleteCondition) {
            this.doScan();
            this.navigator.setup(this.enemies);
        }
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        if (this.enemies.get(scannedRobotEvent.getName()) == null) {
            Enemy enemy = new Enemy(scannedRobotEvent.getName(), this, this.navigator);
            enemy.readData();
            this.enemies.put(scannedRobotEvent.getName(), enemy);
        }
        double d = super.getHeadingRadians() + scannedRobotEvent.getBearingRadians();
        double d2 = this.getX() + scannedRobotEvent.getDistance() * Math.sin(d);
        double d3 = this.getY() + scannedRobotEvent.getDistance() * Math.cos(d);
        ((Enemy)this.enemies.get(scannedRobotEvent.getName())).addScan(new Scan(scannedRobotEvent.getHeadingRadians(), scannedRobotEvent.getVelocity(), scannedRobotEvent.getEnergy(), scannedRobotEvent.getTime(), d2, d3));
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        Enemy enemy = (Enemy)this.enemies.get(hitByBulletEvent.getName());
        enemy.addDamageFrom(hitByBulletEvent.getPower());
    }

    public void onBulletMissed(BulletMissedEvent bulletMissedEvent) {
        this.enemies.updateBulletLists();
    }

    public void onBulletHit(BulletHitEvent bulletHitEvent) {
        this.enemies.updateBulletLists();
    }

    public void onBulletHitBullet(BulletHitBulletEvent bulletHitBulletEvent) {
        this.enemies.updateBulletLists();
    }

    public void onHitRobot(HitRobotEvent hitRobotEvent) {
        ++this.robotCollisions;
        if (hitRobotEvent.isMyFault()) {
            this.reverseDirection();
        }
    }

    public void onHitWall(HitWallEvent hitWallEvent) {
        ++this.wallCollisions;
    }

    public void onRobotDeath(RobotDeathEvent robotDeathEvent) {
        ((Enemy)this.enemies.get(robotDeathEvent.getName())).die();
    }

    public void onSkippedTurn(SkippedTurnEvent skippedTurnEvent) {
        ++this.skippedTurns;
    }

    public void onWin(WinEvent winEvent) {
        this.gameOver = true;
        this.enemies.saveData();
        Enumeration enumeration = this.enemies.getAliveEnemyKeys();
        while (enumeration.hasMoreElements()) {
            ((Enemy)this.enemies.get(enumeration.nextElement())).die();
        }
        this.printBattleInfo();
        this.removeCustomEvent((Condition)new RadarTurnCompleteCondition((AdvancedRobot)this));
        this.setTurnGunRightRadians(Math.PI * 8);
        this.setAhead(100.0);
        int n = 0;
        while (n < 40) {
            this.setTurnRightRadians(0.3141592653589793);
            this.execute();
            this.waitFor((Condition)new TurnCompleteCondition((AdvancedRobot)this));
            this.reverseDirection();
            ++n;
        }
    }

    public void onDeath(DeathEvent deathEvent) {
        this.enemies.saveData();
        this.printBattleInfo();
    }

    public void reverseDirection() {
        double d = this.getDistanceRemaining() * (double)this.direction;
        this.direction *= -1;
        this.setAhead(d);
    }

    public double getHeadingRadians() {
        if (this.direction == -1) {
            return Fncts.normAbsRadians(super.getHeadingRadians() + Math.PI);
        }
        return super.getHeadingRadians();
    }

    public void setAhead(double d) {
        double d2 = d * (double)this.direction;
        super.setAhead(d2);
        if (d < 0.0) {
            this.direction *= -1;
        }
    }

    public void setBack(double d) {
        double d2 = d * (double)this.direction;
        super.setBack(d2);
        if (d > 0.0) {
            this.direction *= -1;
        }
    }

    public void setTurnLeftRadiansOptimal(double d) {
        double d2 = Fncts.normRelRadians(d);
        if (Math.abs(d2) > 1.5707963267948966) {
            this.reverseDirection();
            if (d2 < 0.0) {
                d2 = 1.5707963267948966 + d2 % Math.PI / 2.0;
            } else if (d2 > 0.0) {
                d2 = -(1.5707963267948966 - d2 % Math.PI / 2.0);
            }
        }
        this.setTurnLeftRadians(d2);
    }

    public void setTurnRightRadiansOptimal(double d) {
        double d2 = Fncts.normRelRadians(d);
        if (Math.abs(d2) > 1.5707963267948966) {
            this.reverseDirection();
            if (d2 < 0.0) {
                d2 = 1.5707963267948966 + d2 % Math.PI / 2.0;
            } else if (d2 > 0.0) {
                d2 = -(1.5707963267948966 - d2 % Math.PI / 2.0);
            }
        }
        this.setTurnRightRadians(d2);
    }

    public void printBattleInfo() {
        if (this.robotCollisions != 0) {
            this.out.println("Robot collisions: " + this.robotCollisions);
        }
        if (this.wallCollisions != 0) {
            this.out.println("Wall collisions: " + this.wallCollisions);
        }
        if (this.skippedTurns != 0) {
            this.out.println("Skipped turns: " + this.skippedTurns);
        }
        this.out.println(this.enemies);
    }
}

