/*
 * Decompiled with CFR 0.152.
 */
package ds.gun.dsgf;

import ds.constant.ConstantManager;
import ds.gun.AbstractGun;
import ds.gun.VirtualBullet;
import ds.targeting.IVirtualBot;
import java.awt.geom.Point2D;

public class IndexedVirtualBullet
extends VirtualBullet {
    private int m_angleIndex;
    private double m_hitChance;

    public IndexedVirtualBullet(IVirtualBot target, AbstractGun gun, Point2D.Double startPosition, int angleIndex, double power, double maxEscapeAngle, double hitChances) {
        super(target, gun, startPosition, IndexedVirtualBullet.angleIndex2Angle(target, angleIndex, maxEscapeAngle), power);
        this.m_angleIndex = angleIndex;
        this.m_hitChance = hitChances;
    }

    public int getAngleIndex() {
        return this.m_angleIndex;
    }

    protected static double angleIndex2Angle(IVirtualBot target, int angleIndex, double maxEscapeAngle) {
        int nbSamples = (int)ConstantManager.getInstance().getIntegerConstant("gun.dsgf.nbSamples").longValue();
        double step = 1.0 / (double)nbSamples;
        double angle = (double)(angleIndex -= nbSamples / 2) * step * maxEscapeAngle * 2.0;
        return target.getLateralDirection() * angle + target.getAbsoluteBearingRadians();
    }

    public double getHitChance() {
        return this.m_hitChance;
    }
}

