/*
 * Decompiled with CFR 0.152.
 */
package nic;

import java.util.Vector;
import nic.AntiGravityMove;
import nic.CornerAntiGrav;
import nic.CornerPattern;
import nic.MovementStrategy;
import nic.Nicator;
import nic.OnevOneMove;

public class MovementManager {
    Nicator rob;
    final double PI = Math.PI;
    MovementStrategy currentstrategy;
    Vector strategies;

    public MovementManager(Nicator pRob) {
        this.rob = pRob;
        this.strategies = new Vector();
        this.strategies.add(new AntiGravityMove(this.rob));
        this.strategies.add(new CornerPattern(this.rob));
        this.strategies.add(new OnevOneMove(this.rob));
        this.strategies.add(new CornerAntiGrav(this.rob));
        this.currentstrategy = (MovementStrategy)this.strategies.elementAt(0);
    }

    public void move() {
        if (this.rob.getTime() > 8L) {
            this.selectStrategy();
        }
        int i = 0;
        while (i < this.strategies.size()) {
            ((MovementStrategy)this.strategies.elementAt(i)).maintenance();
            ++i;
        }
        this.currentstrategy.move();
    }

    public void selectStrategy() {
        MovementStrategy ms = (MovementStrategy)this.strategies.elementAt(0);
        int beststrategy = 0;
        double beststrategygoodness = ms.goodness();
        int i = 1;
        while (i < this.strategies.size()) {
            ms = (MovementStrategy)this.strategies.elementAt(i);
            double currentgoodness = ms.goodness();
            if (currentgoodness > beststrategygoodness) {
                beststrategygoodness = currentgoodness;
                beststrategy = i;
            }
            ++i;
        }
        this.currentstrategy = (MovementStrategy)this.strategies.elementAt(beststrategy);
    }

    void goTo(double x, double y) {
        double dist = 20.0;
        double angle = Math.toDegrees(this.rob.hf.absbearing(this.rob.getX(), this.rob.getY(), x, y));
        double r = this.turnTo(angle);
        this.rob.setAhead(dist * r);
    }

    int turnTo(double angle) {
        int dir;
        double ang = this.rob.hf.normaliseBearing(this.rob.getHeading() - angle);
        if (ang > 90.0) {
            ang -= 180.0;
            dir = -1;
        } else if (ang < -90.0) {
            ang += 180.0;
            dir = -1;
        } else {
            dir = 1;
        }
        this.rob.setTurnLeft(ang);
        return dir;
    }

    boolean incorner() {
        if (this.rob.getX() < 160.0 && this.rob.getY() < 160.0) {
            return true;
        }
        if (this.rob.getX() > this.rob.getBattleFieldWidth() - 160.0 && this.rob.getY() < 160.0) {
            return true;
        }
        if (this.rob.getX() < 160.0 && this.rob.getY() > this.rob.getBattleFieldHeight() - 160.0) {
            return true;
        }
        return this.rob.getX() > this.rob.getBattleFieldWidth() - 160.0 && this.rob.getY() > this.rob.getBattleFieldHeight() - 160.0;
    }
}

