/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith.Waves;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import rdt.AgentSmith.IDebugDrawer;
import rdt.AgentSmith.IRobot;
import rdt.AgentSmith.Waves.WaveData;
import rdt.AgentSmith.Waves.WaveManagerBase;

public class WaveDebug
implements IDebugDrawer {
    private IRobot _robot;
    private WaveManagerBase _waveManager;

    public WaveDebug(IRobot robot, WaveManagerBase waveManager) {
        this._robot = robot;
        this._waveManager = waveManager;
        robot.RegisterDebugDrawer(this);
    }

    @Override
    public void DebugDraw(Graphics2D graphics2D) {
        graphics2D.setColor(Color.orange);
        ArrayList<WaveData> waves = this._waveManager.GetActiveWaves();
        for (int waveIndex = 0; waveIndex < waves.size(); ++waveIndex) {
            WaveData wave = waves.get(waveIndex);
            this.DebugDrawWave(wave, graphics2D);
        }
    }

    private void DebugDrawWave(WaveData waveData, Graphics2D graphics2D) {
        int waveDistance = (int)Math.round(waveData.GetDistanceForTick(this._robot.getTime()));
        int x = (int)Math.round(waveData.OriginX);
        int y = (int)Math.round(waveData.OriginY);
        graphics2D.drawOval(x - waveDistance, y - waveDistance, waveDistance * 2, waveDistance * 2);
    }
}

