/*
 * Decompiled with CFR 0.152.
 */
package dk.predict;

import dk.Base;
import dk.Enemy;
import dk.Histogram;
import dk.Point;
import dk.Util;
import dk.predict.Factors;
import dk.predict.Predictor;
import dk.predict.Tracer;

public class Straight
extends Predictor {
    public Straight(Enemy enemy) {
        super(enemy);
    }

    public static Predictor.Factory factory() {
        return new Predictor.Factory(){

            public Predictor newInstance(Enemy e) {
                return new Straight(e);
            }
        };
    }

    protected Point getEstimatedPosition(Point start) {
        return Util.clamp(start);
    }

    public Point getEstimatedPosition(Base robot, long time) {
        return this.getEstimatedPosition(this.enemy_.getEstimatedPosition(robot.getTime()));
    }

    public Point getEstimatedPosition(Base robot, Tracer t, long time) {
        Factors f = t.getFactors();
        return this.getEstimatedPosition(f.getPosition());
    }

    public void tracerDidHit(Base robot, Tracer t, Histogram h) {
        Factors f = t.getFactors();
        double angle = this.getPredictedAngleForTracer(robot, t);
        double actualAngle = t.getActualAngle();
        double estimatedDistance = Util.range(t.getRobotStartPosition(), t.getTarget().getEstimatedPosition(robot.getTime()));
        double missDistance = Math.sin(Math.abs(angle - actualAngle)) * estimatedDistance;
        if (missDistance <= 18.0) {
            h.recordSuccess(this);
        } else {
            h.recordFailure(this);
        }
    }
}

