/*
 * Decompiled with CFR 0.152.
 */
package DM.mega;

import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.util.Utils;

class InPlight {
    private final Ellipse2D.Double waveFront;
    private final Point2D.Double source;
    final double groundHeading;
    final double mEA;
    final double velocity;
    final long fireTime;
    final long refTime;
    final float[] key;
    final int dir;
    final boolean isReal;
    final boolean isRange;
    private boolean isActive;

    InPlight(double d, double d2, double d3, double d4, long l, int n, float[] fArray, boolean bl, boolean bl2) {
        this.source = new Point2D.Double(d, d2);
        this.mEA = Math.asin(8.0 / d4);
        this.velocity = d4;
        this.groundHeading = d3;
        this.fireTime = l;
        this.dir = n;
        this.isRange = bl2;
        this.isActive = true;
        this.isReal = bl;
        this.waveFront = new Ellipse2D.Double(d - d4, d2 - d4, 2.0 * d4, 2.0 * d4);
        this.refTime = l + 1L;
        this.key = fArray;
    }

    Ellipse2D setRefTime(long l) {
        double d = (double)(l - this.fireTime) * this.velocity;
        this.waveFront.setFrame(this.source.x - d, this.source.y - d, 2.0 * d, 2.0 * d);
        return this.waveFront;
    }

    double[] project(double d, double d2) {
        double d3 = (d2 - (double)this.fireTime) * this.velocity;
        return new double[]{this.source.x + Math.sin(d) * d3, this.source.y + Math.cos(d) * d3};
    }

    boolean checkHit(Point2D.Double double_, long l) {
        return this.setRefTime(l).intersects(new Rectangle2D.Double(double_.x - 18.0, double_.y - 18.0, 36.0, 36.0));
    }

    boolean breaks(Point2D.Double double_, long l) {
        return this.source.distance(double_) <= (double)(l - this.fireTime) * this.velocity;
    }

    long timeTillBreak(Point2D.Double double_, long l) {
        return (long)Math.ceil((this.source.distance(double_) - (double)(l - this.fireTime) * this.velocity) / this.velocity);
    }

    double getOffsetFactor(Point2D.Double double_) {
        return this.limit(-1.0, Utils.normalRelativeAngle((double)(Math.atan2(double_.x - this.source.x, double_.y - this.source.y) - this.groundHeading)) / this.mEA, 1.0) * (double)this.dir;
    }

    double getOffsetFactor(double d, double d2) {
        return this.limit(-1.0, Utils.normalRelativeAngle((double)(Math.atan2(d - this.source.x, d2 - this.source.y) - this.groundHeading)) / this.mEA, 1.0) * (double)this.dir;
    }

    double getOffsetFactor(double d) {
        return Utils.normalRelativeAngle((double)(d - this.groundHeading)) / this.mEA * (double)this.dir;
    }

    double sourceX() {
        return this.source.x;
    }

    double sourceY() {
        return this.source.y;
    }

    void setInactive() {
        this.isActive = false;
    }

    boolean isActive() {
        return this.isActive;
    }

    double sourceDist(Point2D.Double double_) {
        return this.source.distance(double_);
    }

    private double limit(double d, double d2, double d3) {
        return Math.max(d, Math.min(d2, d3));
    }

    public int hashCode() {
        return this.source.hashCode() ^ Double.valueOf(this.groundHeading).hashCode() ^ Double.valueOf(this.mEA).hashCode() ^ Double.valueOf(this.velocity).hashCode() ^ (int)this.fireTime ^ this.dir;
    }

    public boolean equals(Object object) {
        if (object instanceof InPlight) {
            InPlight inPlight = (InPlight)object;
            return this.fireTime == inPlight.fireTime;
        }
        return false;
    }

    public String toString() {
        return "Wave: " + this.fireTime + " Vel: " + this.velocity;
    }
}

