/*
 * Decompiled with CFR 0.152.
 */
package mb.movement;

import mb.MBRobot;
import mb.core.Coordinates;
import mb.movement.Movement;
import robocode.HitByBulletEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;

public class DistanceBasedDodgingMovement
extends Movement {
    private int dodgingTime = 0;
    private long lastToggleTime = 0L;
    private static int powerSegments = 10;
    private static int[] bulletPower = new int[powerSegments];

    public DistanceBasedDodgingMovement(MBRobot me) {
        super(me);
    }

    @Override
    public void onRobotFired(ScannedRobotEvent event) {
        if (this.getTime() - this.lastToggleTime < (long)this.dodgingTime || this.isInCorner(this.getMyCoordinates())) {
            return;
        }
        double bulletFlightTime = event.getDistance() / Rules.getBulletSpeed((double)(this.getMaxPowerSegment() / 3));
        this.dodgingTime = (int)(bulletFlightTime - Math.max(0.5, Math.random()) * 5.0);
        this.lastToggleTime = this.getTime();
        this.toggleDirection();
    }

    @Override
    public void onHitByBullet(HitByBulletEvent event) {
        int n = (int)event.getPower() * 3;
        bulletPower[n] = bulletPower[n] + 1;
        super.onHitByBullet(event);
    }

    public String toString() {
        return "DistanceBasedDodgingMovement []";
    }

    private int getMaxPowerSegment() {
        int max = powerSegments / 2;
        int i = 0;
        while (i < powerSegments) {
            if (bulletPower[i] > bulletPower[max]) {
                max = i;
            }
            ++i;
        }
        return max;
    }

    private boolean isInCorner(Coordinates pos) {
        int cornerDistance = 100;
        if (pos.getX() < (double)cornerDistance && pos.getY() < (double)cornerDistance) {
            return true;
        }
        if (pos.getX() < (double)cornerDistance && pos.getY() > this.battleFieldHeight - (double)cornerDistance) {
            return true;
        }
        if (pos.getX() > this.battleFieldWidth - (double)cornerDistance && pos.getY() < (double)cornerDistance) {
            return true;
        }
        return pos.getX() > this.battleFieldWidth - (double)cornerDistance && pos.getY() > this.battleFieldHeight - (double)cornerDistance;
    }
}

