/*
 * Decompiled with CFR 0.152.
 */
package mb.utils;

import java.awt.Color;
import java.awt.Graphics2D;
import mb.core.Coordinates;

public class PaintUtils {
    private Graphics2D graphic;

    public PaintUtils(Graphics2D graphic) {
        this.graphic = graphic;
    }

    public void paintVector(Coordinates start, Coordinates end) {
        this.graphic.setColor(Color.orange);
        this.graphic.drawLine((int)start.getX(), (int)start.getY(), (int)end.getX(), (int)end.getY());
    }

    public void paintVector(Coordinates start, double angle) {
        this.paintVectorRadians(start, Math.toRadians(angle), 100.0);
    }

    public void paintVector(Coordinates start, double angle, double length) {
        this.paintVectorRadians(start, Math.toRadians(angle), length);
    }

    public void paintVectorRadians(Coordinates start, double radians, double length) {
        this.graphic.setColor(Color.orange);
        double endX = start.getX() + Math.sin(radians) * length;
        double endY = start.getY() + Math.cos(radians) * length;
        Coordinates end = new Coordinates(endX, endY);
        this.paintVector(start, end);
    }
}

