/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.patterns;

import florent.XSeries.patterns.Blackboard;
import florent.XSeries.patterns.KnowledgeSource;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Control<T extends KnowledgeSource> {
    private HashSet<T> sources;
    private Blackboard<T> blackboard;

    public Control(Blackboard<T> blackboard) {
        this.blackboard = blackboard;
        this.sources = new HashSet();
    }

    public Iterator<T> sourceIterator() {
        return this.sources.iterator();
    }

    public void loop() {
        for (KnowledgeSource source : this.sources) {
            source.execCondition();
            source.updateBlackboard(this.blackboard);
        }
    }

    public void attachKnowledgeSource(T source) {
        this.sources.add(source);
    }

    public void detachKnowledgeSource(T source) {
        this.sources.remove(source);
    }
}

