/*
 * Decompiled with CFR 0.152.
 */
package agd.util;

import agd.predict.TargetPrediction;
import agd.predict.Trackable;
import agd.util.Aim;
import agd.util.AimStrategy;
import agd.util.Compass;
import agd.util.Coord;
import agd.util.Enemy;
import agd.util.RobotInformation;
import agd.util.World;
import robocode.AdvancedRobot;

public class LinearSpread
implements AimStrategy {
    RobotInformation ri = null;
    AdvancedRobot ar = null;
    Coord[] targetPoint = new Coord[3];
    long targetTime;
    int shotIndex = 0;

    public LinearSpread(RobotInformation ri) {
        this.ri = ri;
        this.ar = ri.getAdvancedRobot();
    }

    public static Prediction iterate(double power, Coord shooterpos, Trackable target, long shotTime, TargetPrediction alg) {
        double bvel = 20.0 - 3.0 * power;
        double distance = 0.0;
        long timeToTarget = 0L;
        Coord estimatedPosition = null;
        Coord previousEstimate = null;
        int i = 0;
        while (i < 10) {
            previousEstimate = estimatedPosition;
            estimatedPosition = alg.predictTarget(target, shotTime + timeToTarget);
            distance = shooterpos.distanceTo(estimatedPosition);
            timeToTarget = (long)(distance / bvel);
            if (previousEstimate != null && estimatedPosition.distanceTo(previousEstimate) < 1.0) break;
            ++i;
        }
        return new Prediction(estimatedPosition, timeToTarget + shotTime);
    }

    public Prediction estimatePosition(Enemy e, double power) {
        TargetPrediction predictionAlg = TargetPrediction.CIRCULAR;
        Coord ourpos = this.ri.getPosition();
        long timeToTarget = 0L;
        Coord estPos = predictionAlg.predictTarget(e, World.getTime() + 1L);
        double distance = ourpos.distanceTo(estPos);
        int roughFlightTime = (int)(distance / World.calcBulletVelocity(power));
        predictionAlg = e.isDisabled() ? TargetPrediction.STATIONARY : e.getStats().getBestPrediction(roughFlightTime, 0);
        Prediction prediction = LinearSpread.iterate(power, ourpos, e, World.getTime() + 1L, predictionAlg);
        estPos = prediction.getPosition();
        long estTime = prediction.getTime();
        double bfWidth = World.getBattleFieldSize().getX();
        double bfHeight = World.getBattleFieldSize().getY();
        estPos = new Coord(Math.max(estPos.getX(), 0.0), Math.max(estPos.getY(), 0.0));
        estPos = new Coord(Math.min(estPos.getX(), bfWidth), Math.min(estPos.getY(), bfHeight));
        return new Prediction(estPos, estTime);
    }

    public Aim aimAtTarget(Enemy e) {
        if (e == null) {
            return new Aim(new Double(0.0), 0.0);
        }
        if (e.getLastSighting() == null) {
            return new Aim(new Double(0.0), 0.0);
        }
        double power = 3.0;
        if (this.shotIndex == 0) {
            Prediction prediction = this.estimatePosition(e, 3.0);
            this.targetPoint[0] = prediction.getPosition();
            this.targetTime = prediction.getTime();
            Compass perpHeading = new Compass(this.targetPoint[0].headingTo(this.ri.getPosition()).getDegrees() - 90.0);
            this.targetPoint[1] = this.targetPoint[0].applyVector(perpHeading, 80.0);
            this.targetPoint[2] = this.targetPoint[0].applyVector(perpHeading, -80.0);
        }
        Coord estPos = this.targetPoint[this.shotIndex];
        double distance = this.ri.getPosition().distanceTo(estPos);
        if (this.shotIndex != 0) {
            long flightTime = this.targetTime - World.getTime() + 1L;
            double reqBulletVel = distance / (double)flightTime;
            power = (20.0 - reqBulletVel) / 3.0;
        }
        Compass shotHeading = this.ri.getPosition().headingTo(estPos);
        Compass gunHeading = new Compass(this.ar.getGunHeading());
        double gunBearing = gunHeading.bearingTo(shotHeading);
        if (power < 0.1) {
            power = 0.1;
        }
        if (power > 3.0) {
            power = 3.0;
        }
        if (!this.decideToShoot(this.ar.getGunHeat(), gunBearing, power, distance)) {
            power = 0.0;
        } else {
            this.shotIndex = (this.shotIndex + 1) % 3;
            if (World.isDebug()) {
                System.out.println("Shooting at " + e + " power " + World.twodp.format(power));
            }
        }
        return new Aim(new Double(gunBearing), power);
    }

    boolean decideToShoot(double gunHeat, double gunBearing, double power, double distance) {
        double allowedGunDrift = Math.toDegrees(Math.atan(20.0 / distance) / 2.0);
        boolean shoot = true;
        if (gunHeat > 0.0 || Math.abs(gunBearing) > allowedGunDrift || power < 0.1 || power > 4.0) {
            shoot = false;
        }
        return shoot;
    }

    double firePower(double distance, Enemy e) {
        return 0.1;
    }

    static class Prediction {
        private Coord pos;
        private long time;

        public Prediction(Coord pos, long time) {
            this.pos = pos;
            this.time = time;
        }

        public Coord getPosition() {
            return this.pos;
        }

        public long getTime() {
            return this.time;
        }
    }
}

