/*
 * Decompiled with CFR 0.152.
 */
package mmb;

import java.util.Random;
import mmb.Behavior;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;

public abstract class AbstractBehavior
implements Behavior {
    protected AdvancedRobot robot = null;
    protected double enemyBearing = 0.0;
    protected double enemyHeading = 0.0;
    protected double enemyVelocity = 0.0;
    protected double enemyDistance = 800.0;
    protected boolean enemyLocked = false;
    protected Random random = new Random();
    private double lastScanGunHeading = 0.0;
    private double fireSpan = 0.39269908169872414;

    public AbstractBehavior(AdvancedRobot robot) {
        this.robot = robot;
    }

    @Override
    public void setAction() {
        this.setBodyAction();
        this.setGunAction();
        this.setRadarAction();
    }

    protected abstract void setBodyAction();

    protected abstract void setGunAction();

    protected abstract void setRadarAction();

    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
        this.enemyBearing = e.getBearing();
        this.enemyHeading = e.getHeading();
        this.enemyVelocity = e.getVelocity();
        this.enemyDistance = e.getDistance();
        this.enemyLocked = true;
        this.lastScanGunHeading = this.robot.getGunHeading();
    }

    @Override
    public void onHitByBullet(HitByBulletEvent e) {
    }

    @Override
    public void onHitWall(HitWallEvent e) {
    }

    @Override
    public void onHitRobot(HitRobotEvent e) {
    }

    protected double calcolateTriangulation(double bulletVelocity) {
        double triangulation = 0.0;
        double absoluteEnemyBearing = 0.0;
        double angleB = 0.0;
        boolean negative = true;
        double localEnemyBearing = 0.0;
        localEnemyBearing = this.enemyBearing;
        if (localEnemyBearing < 0.0) {
            localEnemyBearing += 360.0;
        }
        if ((absoluteEnemyBearing = localEnemyBearing + this.robot.getHeading()) < 0.0) {
            absoluteEnemyBearing += 360.0;
        } else if (absoluteEnemyBearing >= 360.0) {
            absoluteEnemyBearing -= 360.0;
        }
        absoluteEnemyBearing -= 180.0;
        if (absoluteEnemyBearing < 0.0) {
            absoluteEnemyBearing += 360.0;
        }
        if ((angleB = absoluteEnemyBearing - this.enemyHeading) < 0.0) {
            angleB += 360.0;
        }
        if (angleB > 180.0) {
            angleB = 360.0 - angleB;
            negative = true;
        } else {
            negative = false;
        }
        if (angleB < 0.0) {
            angleB += 360.0;
        }
        angleB = this.toRadiants(angleB);
        triangulation = Math.asin(this.enemyVelocity / bulletVelocity * Math.sin(angleB));
        triangulation = this.toDegrees(triangulation);
        if (negative) {
            return -1.0 * triangulation;
        }
        return triangulation;
    }

    private double toRadiants(double angle) {
        double factor = Math.PI / 180;
        return angle * factor;
    }

    private double toDegrees(double angle) {
        double factor = 57.29577951308232;
        return angle * factor;
    }

    protected double calcolateRadarTurningAngle() {
        double radarError;
        double radarTurningAngle = 0.0;
        double localEnemyBearing = 0.0;
        double correctionAngle = 0.0;
        localEnemyBearing = this.enemyBearing;
        double radarBearing = this.robot.getRadarHeading() - this.robot.getHeading();
        if (radarBearing < 0.0) {
            radarBearing += 360.0;
        }
        if (localEnemyBearing < 0.0) {
            localEnemyBearing += 360.0;
        }
        if ((radarError = localEnemyBearing - radarBearing) < 0.0) {
            radarError += 360.0;
        }
        if (radarError >= 0.0 && radarError < 180.0) {
            if (radarError < 1.5) {
                radarError = 1.5;
            }
            radarTurningAngle = 1.0 * radarError;
        } else {
            if ((radarError = 360.0 - radarError) < 1.5) {
                radarError = 1.5;
            }
            radarTurningAngle = -1.0 * radarError;
        }
        correctionAngle = this.calcolateCorrectionAngle();
        return radarTurningAngle - correctionAngle;
    }

    protected double calcolateGunTurningAngle() {
        double gunError;
        double gunTurningAngle = 0.0;
        double localEnemyBearing = 0.0;
        localEnemyBearing = this.enemyBearing;
        double gunBearing = this.robot.getGunHeading() - this.robot.getHeading();
        if (gunBearing < 0.0) {
            gunBearing += 360.0;
        }
        if (localEnemyBearing < 0.0) {
            localEnemyBearing += 360.0;
        }
        if ((gunError = localEnemyBearing - gunBearing) < 0.0) {
            gunError += 360.0;
        }
        if (gunError >= 0.0 && gunError < 180.0) {
            if (gunError < 1.5) {
                gunError = 1.5;
            }
            gunTurningAngle = 1.0 * gunError;
        } else {
            if ((gunError = 360.0 - gunError) < 1.5) {
                gunError = 1.5;
            }
            gunTurningAngle = -1.0 * gunError;
        }
        return gunTurningAngle;
    }

    private double calcolateCorrectionAngle() {
        double correctionAngle = 0.0;
        double currentGunHeading = 0.0;
        currentGunHeading = this.robot.getGunHeading();
        correctionAngle = currentGunHeading - this.lastScanGunHeading;
        if (correctionAngle < 0.0) {
            correctionAngle += 360.0;
        }
        if (correctionAngle > 180.0) {
            correctionAngle = 360.0 - correctionAngle;
            correctionAngle *= -1.0;
        }
        return correctionAngle;
    }

    protected double getRandomOffset() {
        return this.random.nextDouble() * this.fireSpan - this.fireSpan / 2.0;
    }
}

