/*
 * Decompiled with CFR 0.152.
 */
package barontrozo;

import barontrozo.dataStructures.Pair;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import robocode.Rules;
import robocode.util.Utils;

public class BulletFollower {
    Point2D.Double firePos_;
    Point2D.Double targetPos_;
    double angleBegin_;
    double angleArc_;
    double distance_;
    double bulletSpeed_;
    double bulletPower_;
    double precision_;
    double alreadyWaveEvadePosition_;
    long turnInitial_;
    double velTarget_;
    double headingTarget_;
    double distanceTarget_;
    double centrePosition_;
    double fireAngle_;
    List<Pair<Double>> bulletShadows_;
    int id_ = ++ide_;
    static int ide_ = 0;

    public BulletFollower(Point2D.Double firePos, double angleBegin, double angleArc, double distance, double bulletPower, double precision, long turn, double fireAngle, Point2D.Double targetPos, double velTarget, double headingTarget) {
        this.firePos_ = new Point2D.Double(firePos.getX(), firePos.getY());
        this.targetPos_ = new Point2D.Double(targetPos.getX(), targetPos.getY());
        this.angleBegin_ = angleBegin;
        this.angleArc_ = angleArc;
        this.distance_ = distance;
        this.bulletSpeed_ = Rules.getBulletSpeed((double)bulletPower);
        this.bulletPower_ = bulletPower;
        this.precision_ = precision;
        this.turnInitial_ = turn;
        this.alreadyWaveEvadePosition_ = -1.0;
        this.velTarget_ = velTarget;
        this.headingTarget_ = headingTarget;
        this.distanceTarget_ = targetPos.distance(firePos) / this.bulletSpeed_;
        this.fireAngle_ = fireAngle;
        this.bulletShadows_ = new ArrayList<Pair<Double>>();
    }

    public boolean IsValid(Point2D.Double objetive, long turn) {
        return this.firePos_.distance(objetive) - this.precision_ > this.bulletSpeed_ * (double)(turn - this.turnInitial_);
    }

    public double GetPosition(Point2D.Double objetive) {
        double angle = Math.atan2(objetive.getX() - this.firePos_.getX(), objetive.getY() - this.firePos_.getY());
        angle = Utils.normalRelativeAngle((double)(angle - this.angleBegin_));
        return angle / this.angleArc_;
    }

    public void FoundBulletShadows(BulletFollower myBulletWave) {
        int turn = 1;
        Point2D.Double p1 = new Point2D.Double(0.0, 0.0);
        Point2D.Double p2 = new Point2D.Double(0.0, 0.0);
        double distanceBetweenFires = myBulletWave.firePos_.distance(this.firePos_);
        while (true) {
            double x = Math.sin(myBulletWave.fireAngle_) * myBulletWave.bulletSpeed_;
            double y = Math.cos(myBulletWave.fireAngle_) * myBulletWave.bulletSpeed_;
            p1.setLocation(myBulletWave.firePos_.getX() + x * (double)turn, myBulletWave.firePos_.getY() + y * (double)turn);
            p2.setLocation(myBulletWave.firePos_.getX() + x * (double)(turn - 1), myBulletWave.firePos_.getY() + y * (double)(turn - 1));
            int enemyTurn = (int)(myBulletWave.turnInitial_ + (long)turn - this.turnInitial_);
            if (enemyTurn > 0) {
                double distanceToMe = myBulletWave.firePos_.distance(p2);
                double distanceP1ToEnemyWave = this.firePos_.distance(p1);
                double distanceP2ToEnemyWave = this.firePos_.distance(p2);
                double distanceEnmyBullet = (double)enemyTurn * this.bulletSpeed_;
                if (distanceToMe > distanceBetweenFires) {
                    return;
                }
                if (distanceP1ToEnemyWave <= distanceEnmyBullet) {
                    double ang2;
                    double ang1 = Math.atan2(p1.getX() - this.firePos_.getX(), p1.getY() - this.firePos_.getY());
                    if (distanceP2ToEnemyWave <= distanceEnmyBullet) {
                        ang2 = Math.atan2(p2.getX() - this.firePos_.getX(), p2.getY() - this.firePos_.getY());
                    } else {
                        double part = (distanceEnmyBullet - distanceP1ToEnemyWave) / (distanceP2ToEnemyWave - distanceP1ToEnemyWave);
                        p2.setLocation(myBulletWave.firePos_.getX() + x * ((double)(turn - 1) + part), myBulletWave.firePos_.getY() + y * ((double)(turn - 1) + part));
                        ang2 = Math.atan2(p2.getX() - this.firePos_.getX(), p2.getY() - this.firePos_.getY());
                    }
                    if (Utils.normalRelativeAngle((double)(ang2 - ang1)) < 0.0) {
                        double aux = ang2;
                        ang2 = ang1;
                        ang1 = aux;
                    }
                    ang1 = Utils.normalAbsoluteAngle((double)ang1);
                    ang2 = Utils.normalAbsoluteAngle((double)(ang2 - ang1));
                    this.bulletShadows_.add(new Pair<Double>(ang1, ang2));
                    return;
                }
            }
            ++turn;
        }
    }

    public boolean IsValuePostionOnShadow(double val) {
        for (Pair<Double> angShadow : this.bulletShadows_) {
            double min = Utils.normalAbsoluteAngle((double)((Double)angShadow.first - this.angleBegin_)) / this.angleArc_;
            double max = Utils.normalAbsoluteAngle((double)((Double)angShadow.first + (Double)angShadow.second - this.angleBegin_)) / this.angleArc_;
            if (!(min <= val) || !(val <= max)) continue;
            return true;
        }
        return false;
    }

    public void onPaint(Graphics2D g, Color c, int turn) {
        g.setColor(c);
        double aux = this.bulletSpeed_ * (double)((long)turn - this.turnInitial_);
        g.draw(new Arc2D.Double(this.firePos_.getX() - aux, this.firePos_.getY() - aux, aux * 2.0, aux * 2.0, Math.toDegrees(this.angleBegin_) - 90.0, Math.toDegrees(this.angleArc_), 2));
        g.draw(new Arc2D.Double(this.firePos_.getX() - this.distance_, this.firePos_.getY() - this.distance_, this.distance_ * 2.0, this.distance_ * 2.0, Math.toDegrees(this.angleBegin_) - 90.0, Math.toDegrees(this.angleArc_), 2));
        for (Pair<Double> angShadow : this.bulletShadows_) {
            g.setColor(Color.GREEN);
            g.draw(new Arc2D.Double(this.firePos_.getX() - this.distance_, this.firePos_.getY() - this.distance_, this.distance_ * 2.0, this.distance_ * 2.0, Math.toDegrees((Double)angShadow.first) - 90.0, Math.toDegrees((Double)angShadow.second), 2));
        }
    }
}

