/*
 * Decompiled with CFR 0.152.
 */
package wcsv.melee;

import wcsv.melee.Utils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SelfOrganizingMap {
    public Node head;
    public double[] normalVector;
    public double spreadFactor;
    public int size;
    public int lastAddedIndex;
    private int closestIndex;

    public Node add(double[] v) {
        Node closest = this.closestNode(v);
        Node toAdd = new Node();
        if (closest == null) {
            ++this.size;
            this.head = toAdd;
            return toAdd;
        }
        if (this.distance(closest.featureVector, v) > this.spreadFactor) {
            double prevDist;
            ++this.size;
            double nextDist = closest.next != null ? this.distance(v, closest.next.featureVector) : Double.MAX_VALUE;
            double d = prevDist = closest.prev != null ? this.distance(v, closest.prev.featureVector) : Double.MAX_VALUE;
            if (nextDist < prevDist) {
                toAdd.prev = closest;
                toAdd.next = closest.next;
                if (closest.next != null) {
                    closest.next.prev = toAdd;
                }
                closest.next = toAdd;
                this.lastAddedIndex = this.closestIndex + 1;
            } else {
                toAdd.prev = closest.prev;
                toAdd.next = closest;
                if (closest.prev == null) {
                    this.head = toAdd;
                } else {
                    closest.prev.next = toAdd;
                }
                closest.prev = toAdd;
                this.lastAddedIndex = this.closestIndex;
            }
            return toAdd;
        }
        this.lastAddedIndex = this.closestIndex;
        return closest;
    }

    public double[] get(double[] v) {
        Node closest = this.closestNode(v);
        return closest != null ? closest.buffer : null;
    }

    public Node closestNode(double[] vector) {
        Node temp = this.head;
        Node closest = null;
        double closestDist = Double.MAX_VALUE;
        this.closestIndex = 0;
        int index = 0;
        while (temp != null) {
            double currDist = this.distance(temp.featureVector, vector);
            if (currDist < closestDist) {
                closestDist = currDist;
                closest = temp;
                this.closestIndex = index;
            }
            temp = temp.next;
            ++index;
        }
        return closest;
    }

    public double distance(double[] v1, double[] v2) {
        double dist = 0.0;
        int i = 0;
        while (i < v1.length) {
            dist += Utils.sqr((v1[i] - v2[i]) / this.normalVector[i]);
            ++i;
        }
        return Math.sqrt(dist);
    }

    public void combine(double[] input, Node vector) {
        int i = 0;
        while (i < input.length) {
            vector.featureVector[i] = (vector.featureVector[i] * (double)vector.uses + input[i]) / ((double)vector.uses + 1.0);
            ++i;
        }
    }

    public void combine(double[] inputVector, Node receive, double weight, double addFactor, double bin) {
        int i = 0;
        while (i < receive.buffer.length) {
            int n = i;
            receive.buffer[n] = receive.buffer[n] + addFactor * weight / (Math.abs(bin - (double)i) + 1.0);
            ++i;
        }
        i = 0;
        while (i < inputVector.length) {
            receive.featureVector[i] = (receive.featureVector[i] * (double)receive.uses + inputVector[i] * weight) / ((double)receive.uses + weight);
            ++i;
        }
    }

    public void combineRolling(double[] inputVector, Node receive, double weight, double bin) {
        int i = 0;
        while (i < receive.buffer.length) {
            receive.buffer[i] = Utils.rollingAvg(receive.buffer[i], 1.0 / (Math.abs(bin - (double)i) + 1.0), receive.uses, 1.0, weight);
            ++i;
        }
        i = 0;
        while (i < inputVector.length) {
            receive.featureVector[i] = (receive.featureVector[i] * (double)receive.uses + inputVector[i] * weight) / ((double)receive.uses + weight);
            ++i;
        }
    }

    private final /* synthetic */ void this() {
        this.head = null;
    }

    public SelfOrganizingMap(double[] normal, double spread) {
        this.this();
        this.normalVector = normal;
        this.spreadFactor = spread;
        this.size = 0;
        this.lastAddedIndex = 0;
        this.closestIndex = 0;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Node {
        public int uses;
        public Node next;
        public Node prev;
        double[] featureVector;
        public double[] buffer;

        private final /* synthetic */ void this() {
            this.uses = 0;
            this.featureVector = new double[SelfOrganizingMap.this.normalVector.length];
            this.buffer = new double[41];
        }

        public Node() {
            this.this();
        }
    }
}

