/*
 * Decompiled with CFR 0.152.
 */
package fnc.bandit2002;

import fnc.bandit2002.Position;
import java.io.PrintStream;

public class Force {
    double vx;
    double vy;

    public void setForce(Position arg_p1, Position arg_p2, double arg_strength) {
        double bearing = arg_p2.bearing(arg_p1);
        this.vx = Math.sin(bearing) * arg_strength;
        this.vy = Math.cos(bearing) * arg_strength;
    }

    public void setForce(Position arg_p1, Position arg_p2, double arg_strength, double delta) {
        double bearing = arg_p2.bearing(arg_p1);
        this.vx = Math.sin(bearing + delta) * arg_strength;
        this.vy = Math.cos(bearing + delta) * arg_strength;
    }

    public void add(Force arg_f) {
        this.vx += arg_f.vx;
        this.vy += arg_f.vy;
    }

    public void dump(PrintStream o) {
        o.print("(" + this.vx + ',' + this.vy + ") " + this.bearing() + " : ");
        o.println(Math.round(this.bearing() / (Math.PI * 2) * 360.0));
    }

    public double bearing() {
        double a = Math.atan2(this.vx, this.vy);
        if (a < 0.0) {
            a += Math.PI * 2;
        }
        return a;
    }

    public double strength() {
        return Math.sqrt(this.vx * this.vx + this.vy * this.vy);
    }

    public void swap() {
        double temp = this.vx;
        this.vx = this.vy;
        this.vy = temp;
    }

    public void rotate(double angle) {
        double heading = this.bearing();
        double strength = this.strength();
        this.vx = Math.sin(heading += angle) * strength;
        this.vy = Math.cos(heading) * strength;
    }

    public Force() {
        this.vx = 0.0;
        this.vy = 0.0;
    }

    public Force(Position arg_p1, Position arg_p2, double arg_strength) {
        double bearing = arg_p2.bearing(arg_p1);
        this.vx = Math.sin(bearing) * arg_strength;
        this.vy = Math.cos(bearing) * arg_strength;
    }
}

