/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.strategy;

import alk.lap.LoudAndProud;
import alk.lap.strategy.VirtualBullet;
import alk.lap.strategy.targetting.TargetStrategy;
import alk.lap.utils.DVektor;

public class StatisticBullet
extends VirtualBullet {
    DVektor enemyPosAtFire = null;
    BulletType type = BulletType.CONTINOUS;

    public StatisticBullet(LoudAndProud proud, TargetStrategy tStrategy, BulletType type) {
        super(proud, tStrategy);
        this.type = type;
        this.enemyPosAtFire = proud.getTacticLead().getEnemyPos();
    }

    public void increment() {
        super.increment();
        if (!super.isValid() && this.proud.getTacticLead().isEnemySpotted()) {
            DVektor enemyPos = this.proud.getTacticLead().getEnemyPos();
            double deltaToEmission = this.emittingPosition.getDirectionTo(enemyPos) - this.angle;
            double distanceSinceFire = this.enemyPosAtFire.getDistanceTo(enemyPos);
            double distanceAtFiring = this.emittingPosition.getDistanceTo(enemyPos);
            if (this.type == BulletType.CONTINOUS) {
                this.proud.getStrategicLead().getAnalystsDB().incrementContEnemyHitAngleAtBearing(deltaToEmission, distanceAtFiring);
            } else {
                this.proud.getStrategicLead().getAnalystsDB().incrementEnemyHitAngleAtBearing(deltaToEmission, distanceAtFiring);
                double normedAngle = LoudAndProud.normalRelativeAngle(deltaToEmission);
                this.proud.getStrategicLead().getAnalystsDB().incrementEnemyHitDistance(normedAngle > 0.0 ? distanceSinceFire : -distanceSinceFire);
            }
        }
    }

    public void checkForHit(DVektor enemyPos) {
    }

    protected void draw() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BulletType {
        WAVE,
        CONTINOUS;

    }
}

