/*
 * Decompiled with CFR 0.152.
 */
package catcat20.jewel.iolite.gun.pif;

import catcat20.jewel.iolite.gun.Gun;
import catcat20.jewel.iolite.gun.pif.PIFData;
import catcat20.jewel.iolite.radar.IoliteRadar;
import catcat20.jewel.iolite.utils.BotState;
import catcat20.jewel.iolite.utils.IUtils;
import catcat20.jewel.iolite.utils.Wave;
import catcat20.jewel.iolite.utils.ags.utils.dataStructures.trees.secondGenKD.KdTree;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.TeamRobot;
import robocode.util.Utils;
import voidious.utils.DiaUtils;

public class PlayItForward
extends Gun {
    public boolean isMelee = false;
    double averageDistance = 0.0;
    double bestDistAngle = 0.0;
    public Rectangle2D.Double _fieldRect;
    Point2D.Double myPos = new Point2D.Double();
    public ArrayList<Point2D.Double> poss = new ArrayList();
    public ArrayList<Point2D.Double> possPass = new ArrayList();
    public ArrayList<Double> possDistance = new ArrayList();
    public ArrayList<Double> possPassDistance = new ArrayList();

    public PlayItForward(TeamRobot robot) {
        super(robot);
        this._fieldRect = new Rectangle2D.Double(0.0, 0.0, robot.getBattleFieldWidth(), robot.getBattleFieldHeight());
    }

    @Override
    public void init() {
    }

    @Override
    public void execute() {
        this.myPos.setLocation(this.robot.getX(), this.robot.getY());
        for (BotState en : IoliteRadar.enemies.values()) {
            if (!en.alive) continue;
            double distLast30 = en.distance(en.oldPositions.get(Math.min(30, en.oldPositions.size() - 1)));
            double distLast60 = en.distance(en.oldPositions.get(Math.min(60, en.oldPositions.size() - 1)));
            double distLast120 = en.distance(en.oldPositions.get(Math.min(120, en.oldPositions.size() - 1)));
            PIFData data = new PIFData();
            data.enemyData = (BotState)en.clone();
            data.dirChangeTime = en.dirChangeTime;
            data.distLast30 = distLast30;
            data.distLast60 = distLast60;
            data.distLast120 = distLast120;
            data.ID = en.pifID++;
            if (en.lastPIFData != null) {
                data.back = en.lastPIFData;
                en.lastPIFData.next = data;
            }
            en.lastPIFData = data;
            if (this.isMelee) {
                en.meleePifTree.addPoint(this.dataPointFromWaveRecord(data, false), data);
                continue;
            }
            en.pifTree.addPoint(this.dataPointFromWaveRecord(data, false), data);
        }
    }

    @Override
    public void onBulletHit(Wave w, BulletHitEvent e) {
    }

    @Override
    public void onBulletHitBullet(Wave w, BulletHitBulletEvent e) {
    }

    @Override
    public void onRoundEnded(RoundEndedEvent e) {
    }

    @Override
    public double getOffset() {
        this.poss.clear();
        this.possPass.clear();
        this.possDistance.clear();
        this.possPassDistance.clear();
        Double bestAngle = null;
        double bestDensity = Double.NEGATIVE_INFINITY;
        ArrayList<Angle> angles = new ArrayList<Angle>();
        for (BotState en : IoliteRadar.enemies.values()) {
            if (!en.alive || this.robot.isTeammate(en.name)) continue;
            double bandwidth = 36.0 / this.myPos.distance(en);
            List list = null;
            list = this.isMelee ? en.meleePifTree.nearestNeighbor(this.dataPointFromWaveRecord(en.lastPIFData, true), (int)(100.0 / IoliteRadar.others), true) : en.pifTree.nearestNeighbor(this.dataPointFromWaveRecord(en.lastPIFData, true), 30, true);
            double angleCount = 0.0;
            for (KdTree.Entry pifDataEntry : list) {
                Point2D.Double pos = this.simPos((PIFData)pifDataEntry.value, en, Rules.getBulletSpeed((double)IoliteRadar.calculatePower()), pifDataEntry.distance);
                if (pos != null && this._fieldRect.contains(pos)) {
                    Angle angle = new Angle();
                    angle.angle = IUtils.absoluteBearing(this.myPos, pos);
                    angle.weight = 1.0 / Math.sqrt(pifDataEntry.distance) * (this.isMelee ? 1.0 / (en.distance * en.distance) : 1.0) * (this.isMelee ? 1.0 / (en.energy * en.energy) : 1.0);
                    if (this.isMelee && en.name.equals(IoliteRadar.getNearestEnemy().name)) {
                        angle.weight *= 1440000.0 / (IoliteRadar.getNearestEnemy().distance * IoliteRadar.getNearestEnemy().distance);
                    }
                    angle.bandwidth = bandwidth;
                    angles.add(angle);
                }
                this.averageDistance += pifDataEntry.distance;
                angleCount += 1.0;
            }
            this.averageDistance /= angleCount;
        }
        for (Angle a : angles) {
            double density = 0.0;
            for (Angle b : angles) {
                if (a == b) continue;
                double ux = Utils.normalRelativeAngle((double)(a.angle - b.angle)) / a.bandwidth;
                density += Math.exp(-0.5 * ux * ux) * b.weight;
            }
            if (!(density > bestDensity)) continue;
            bestAngle = a.angle;
            this.bestDistAngle = bestAngle;
            bestDensity = density;
        }
        if (bestAngle == null) {
            if (IoliteRadar.getNearestEnemy() != null) {
                return IUtils.absoluteBearing(this.myPos, IoliteRadar.getNearestEnemy());
            }
            return 0.0;
        }
        return bestAngle;
    }

    public Point2D.Double simPos(PIFData data, BotState currentTr, double bulletVelocity, double dataDistance) {
        if (data == null) {
            return null;
        }
        Point2D.Double pos = (Point2D.Double)currentTr.clone();
        int count = (int)(currentTr.distance / bulletVelocity);
        PIFData calcData = data;
        double velocity = currentTr.velocity;
        double heading = currentTr.heading;
        ArrayList<Point2D.Double> tempPoss = new ArrayList<Point2D.Double>();
        boolean isArrived = false;
        int counter = 0;
        double distanceTraveled = 0.0;
        while (!isArrived && counter < count + 50) {
            ++counter;
            if (calcData.back != null) {
                heading += Utils.normalRelativeAngle((double)(calcData.enemyData.heading - calcData.back.enemyData.heading));
                velocity += calcData.enemyData.velocity - calcData.back.enemyData.velocity;
            } else if (calcData.next != null) {
                heading += Utils.normalRelativeAngle((double)(calcData.next.enemyData.heading - calcData.enemyData.heading));
                velocity += calcData.next.enemyData.velocity - calcData.enemyData.velocity;
            }
            heading = Utils.normalAbsoluteAngle((double)heading);
            velocity = IUtils.limit(-8.0, velocity, 8.0);
            pos = IUtils.project(pos, this.effectiveHeading(heading, IUtils.sign(velocity)), Math.abs(velocity));
            if (calcData.next == null) {
                return null;
            }
            tempPoss.add(pos);
            this.possPassDistance.add(dataDistance);
            calcData = calcData.next;
            distanceTraveled += bulletVelocity;
            if (!(this.myPos.distance(pos) < distanceTraveled)) continue;
            isArrived = true;
        }
        this.possPass.addAll(tempPoss);
        this.poss.add(pos);
        this.possDistance.add(dataDistance);
        return pos;
    }

    public double effectiveHeading(double targetHeading, double targetVelocitySign) {
        return Utils.normalAbsoluteAngle((double)(targetHeading + (targetVelocitySign == 1.0 ? 0.0 : Math.PI)));
    }

    public double[] dataPointFromWaveRecord(PIFData data, boolean aiming) {
        BotState en = data.enemyData;
        double absBearing = data.enemyData.absBearing;
        return new double[]{(en.velocity * Math.sin(en.heading - absBearing) + 8.0) / 16.0, (en.velocity * -Math.cos(en.heading - absBearing) + 8.0) / 16.0, (en.velocity + 8.0) / 16.0, en.distance / 1300.0, en.distance / data.bulletVelocity() / 130.0, 1.0 / (1.0 + data.dirChangeTime), data.distLast30 / 240.0, data.distLast60 / 480.0, data.distLast120 / 960.0, (IUtils.accel(en.oldVelocity, en.velocity) + 2.0) / 3.0};
    }

    @Override
    public Color getColor() {
        return Color.magenta;
    }

    @Override
    public String getLabel() {
        return "PIF";
    }

    @Override
    public void onPaint(Graphics2D g) {
        Color color;
        Point2D.Double pos;
        Collections.reverse(this.possPass);
        Collections.reverse(this.possPassDistance);
        Collections.reverse(this.possDistance);
        Collections.reverse(this.poss);
        double sumSquares = 0.0;
        for (Double ppDist : this.possPassDistance) {
            sumSquares += PlayItForward.square(this.averageDistance - ppDist);
        }
        double stDev = Math.sqrt(sumSquares / (double)this.possPassDistance.size());
        for (int i = 0; i < this.possPass.size(); ++i) {
            pos = this.possPass.get(i);
            color = PlayItForward.riskColor(this.possPassDistance.get(i), this.averageDistance, stDev, false, 1.0);
            g.setColor(color);
            g.drawOval((int)pos.x - 2, (int)pos.y - 2, 4, 4);
        }
        sumSquares = 0.0;
        for (Double ppDist : this.possDistance) {
            sumSquares += PlayItForward.square(this.averageDistance - ppDist);
        }
        stDev = Math.sqrt(sumSquares / (double)this.possDistance.size());
        for (int i = 0; i < this.poss.size(); ++i) {
            pos = this.poss.get(i);
            color = PlayItForward.riskColor(this.possDistance.get(i), this.averageDistance, stDev, false, 1.0);
            g.setColor(color);
            g.drawRect((int)pos.x - 18, (int)pos.y - 18, 36, 36);
        }
        Point2D.Double target = IUtils.project(this.myPos, this.bestDistAngle, 1500.0);
        g.setColor(Color.red);
        g.drawLine((int)this.myPos.x, (int)this.myPos.y, (int)target.x, (int)target.y);
    }

    public static Color riskColor(double risk, double avg, double stDev, boolean safestYellow, double maxStDev) {
        if (risk < 1.0E-7 && safestYellow) {
            return Color.yellow;
        }
        return new Color((int)DiaUtils.limit(0.0, 255.0 * (risk - (avg - maxStDev * stDev)) / (2.0 * maxStDev * stDev), 255.0), 0, (int)DiaUtils.limit(0.0, 255.0 * (avg + maxStDev * stDev - risk) / (2.0 * maxStDev * stDev), 255.0), 180);
    }

    public static double square(double d) {
        return d * d;
    }

    public static double standardDeviation(double[] values) {
        double avg = PlayItForward.average(values);
        double sumSquares = 0.0;
        for (double value : values) {
            sumSquares += PlayItForward.square(avg - value);
        }
        return Math.sqrt(sumSquares / (double)values.length);
    }

    public static double average(double[] values) {
        double sum = 0.0;
        for (double value : values) {
            sum += value;
        }
        return sum / (double)values.length;
    }

    public class Angle {
        public double angle;
        public double weight;
        public double bandwidth;
    }
}

