/*
 * Decompiled with CFR 0.152.
 */
package geep.mini;

import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;

public class GPBotA
extends AdvancedRobot {
    public static final double MOVE_MULTIPLIER = 300.0;
    public static final double TURN_MULTIPLIER = 180.0;
    public static final double ENERGY_MULTIPLIER = 100.0;
    public static final int TANK = 0;
    public static final int GUN = 1;
    public static final int RADAR = 2;
    private static double enemyDistance;
    private static double enemyBearing;
    private static double enemyVelocity;
    private static double enemyHeading;
    private static double enemyEnergy;

    public void run() {
        this.setColors(Color.RED, Color.RED, Color.WHITE);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        enemyDistance = scannedRobotEvent.getDistance() / 300.0;
        enemyBearing = scannedRobotEvent.getBearing() / 180.0;
        enemyHeading = (scannedRobotEvent.getHeading() - this.getHeading()) / 180.0;
        enemyVelocity = scannedRobotEvent.getVelocity() / 300.0;
        enemyEnergy = scannedRobotEvent.getEnergy() / 100.0;
        this.move(0.0 - (this.getEnergy() / 100.0 + enemyEnergy + Math.cos(Math.PI * Math.abs(Math.random() * 2.0 - 1.0)) + enemyEnergy + enemyBearing + Math.abs(enemyBearing > 0.0 ? enemyDistance : enemyBearing + Math.cos(Math.PI * (0.0 - enemyVelocity)) + Math.abs(0.0 - enemyDistance)) + this.getEnergy() / 100.0 - enemyBearing));
        this.turn(0, -0.6672535760653446 > Math.cos(Math.PI * Math.abs(enemyBearing)) ? Math.cos(Math.PI * (enemyBearing > 0.0 ? (Math.abs(0.0 - enemyVelocity + enemyBearing + Math.abs(Math.random() * 2.0 - 1.0)) > Math.abs(Math.abs(enemyBearing)) - (enemyBearing + Math.abs(enemyBearing) + enemyEnergy > 0.0 ? enemyBearing : enemyBearing) ? Math.abs(Math.abs(enemyBearing)) : (enemyBearing > 0.0 ? enemyDistance : ((enemyBearing > 0.0 ? this.nearestWall()[0] + enemyHeading : enemyBearing) > 0.0 ? Math.cos(Math.PI * (0.0 - enemyVelocity)) + enemyBearing : Math.abs(Math.random() * 2.0 - 1.0)))) : enemyBearing)) : Math.cos(Math.PI * this.nearestWall()[1]));
        this.turn(1, ((Math.abs(Math.random() * 2.0 - 1.0) > Math.cos(Math.PI * Math.abs(Math.random() * 2.0 - 1.0)) + this.nearestWall()[0] ? enemyVelocity : enemyDistance) > 0.0 ? enemyBearing : (enemyBearing > 0.0 ? (Math.cos(Math.PI * Math.abs(Math.cos(Math.PI * (this.getEnergy() / 100.0)))) + (((enemyEnergy > 0.0 ? enemyVelocity : this.getEnergy() / 100.0) > 0.0 ? enemyEnergy : this.nearestWall()[0] - enemyBearing) == 0.0 ? 0.0 : Math.acos(this.nearestWall()[1] * enemyHeading) * 57.29577951308232 / 180.0 / ((enemyEnergy > 0.0 ? enemyVelocity : this.getEnergy() / 100.0) > 0.0 ? enemyEnergy : this.nearestWall()[0] - enemyBearing)) > this.getEnergy() / 100.0 - (this.getEnergy() / 100.0 + enemyEnergy + enemyEnergy > 0.0 ? enemyBearing : enemyBearing) ? Math.abs(Math.abs(enemyBearing)) : enemyDistance) : enemyBearing)) > 0.0 ? enemyBearing : enemyBearing);
        this.turn(2, 0.0 - Math.abs(Math.cos(Math.PI * (this.getEnergy() / 100.0) - (enemyBearing > 0.0 ? this.getEnergy() / 100.0 - enemyBearing : enemyBearing)) + this.getEnergy() / 100.0 - enemyBearing + enemyEnergy + enemyDistance + this.nearestWall()[0]) > 0.0 ? enemyBearing : enemyBearing);
        this.shoot(Math.abs(Math.cos(Math.PI * Math.abs(enemyBearing))) + this.nearestWall()[0] + enemyDistance + this.nearestWall()[0] + enemyBearing + this.getEnergy() / 100.0 + enemyEnergy + enemyDistance + this.nearestWall()[0] + ((enemyBearing + enemyEnergy > 0.0 ? enemyBearing : enemyBearing) + (0.0 - (enemyVelocity - this.getEnergy() / 100.0)) > 0.0 - (enemyBearing > 0.0 ? enemyDistance : ((enemyBearing > 0.0 ? enemyBearing : enemyBearing) > 0.0 ? Math.abs(enemyBearing) + Math.abs(Math.random() * 2.0 - 1.0) : Math.abs(Math.random() * 2.0 - 1.0))) ? enemyVelocity : enemyDistance) + enemyEnergy);
    }

    public void onHitRobot(HitRobotEvent hitRobotEvent) {
        enemyDistance = 0.0;
        enemyBearing = hitRobotEvent.getBearing() / 180.0;
        enemyEnergy = hitRobotEvent.getEnergy() / 100.0;
    }

    private double[] nearestWall() {
        double[] dArray = new double[]{this.getBattleFieldHeight() - this.getY(), 0.0};
        double[] dArray2 = dArray;
        if (dArray2[0] > this.getBattleFieldWidth() - this.getX()) {
            dArray2 = new double[]{this.getBattleFieldWidth() - this.getX(), 90.0};
        }
        if (dArray2[0] > this.getY()) {
            dArray2 = new double[]{this.getY(), 180.0};
        }
        if (dArray2[0] > this.getX()) {
            dArray2 = new double[]{this.getX(), 270.0};
        }
        dArray2[1] = dArray2[1] - this.getHeading();
        dArray2[0] = dArray2[0] / 300.0;
        dArray2[1] = dArray2[1] / 180.0;
        return dArray2;
    }

    public double move(double d) {
        this.setAhead(300.0 * d);
        return d;
    }

    private double turn(int n, double d) {
        switch (n) {
            case 0: {
                this.setTurnRight(GPBotA.normalizeAngle(180.0 * d));
                break;
            }
            case 1: {
                double d2 = d + (this.getHeading() - this.getGunHeading()) / 180.0;
                this.setTurnGunRight(GPBotA.normalizeAngle(180.0 * d2));
                break;
            }
            case 2: {
                double d3 = d + (this.getHeading() - this.getRadarHeading()) / 180.0;
                this.setTurnRadarRight(GPBotA.normalizeAngle(180.0 * d3));
            }
        }
        return d;
    }

    public double shoot(double d) {
        if (d > 0.0) {
            Bullet bullet = this.setFireBullet(3.0 * d);
        }
        return d;
    }

    private static double normalizeAngle(double d) {
        while (d > 180.0) {
            d -= 360.0;
        }
        while (d < -180.0) {
            d += 360.0;
        }
        return d;
    }
}

