/*
 * Decompiled with CFR 0.152.
 */
package kano.gamma;

import kano.gamma.Enemy;
import kano.gamma.KanoGamma;

public class FireMgr {
    KanoGamma bot;

    public FireMgr(KanoGamma bot) {
        this.bot = bot;
    }

    public void fire() {
        Enemy target = this.bot.enemyMgr.currentTarget;
        if (target == null) {
            return;
        }
        double firePower = this.calculateFirePower(target);
        if (this.bot.getOthers() == 1 && target.isOscilating && target.avgOscilTime != 0.0) {
            this.oscilateTarget(target, firePower);
        } else if (target.distance > 500.0 || target.distance < 150.0) {
            this.directTarget(target, firePower);
        } else {
            this.moveTarget(target, firePower);
        }
    }

    public void directTarget(Enemy target, double firePower) {
        this.doFire(firePower, target, this.bot.getVectorAngle(this.bot.getX(), this.bot.getY(), target.x, target.y));
    }

    public void moveTarget(Enemy target, double firePower) {
        long time = this.bot.getTime() + (long)((int)(target.distance / (20.0 - 3.0 * firePower)));
        double d1 = this.bot.getRange(this.bot.getX(), this.bot.getY(), target.guessX(time), target.guessY(time));
        time = this.bot.getTime() + (long)((int)(d1 / (20.0 - 3.0 * firePower)));
        double tx = target.guessX(time);
        double ty = target.guessY(time);
        if (tx < 0.0) {
            tx = -tx;
        } else if (tx > this.bot.getBattleFieldWidth()) {
            tx = this.bot.getBattleFieldWidth() - (tx - this.bot.getBattleFieldWidth());
        }
        if (ty < 0.0) {
            ty = -ty;
        } else if (ty > this.bot.getBattleFieldHeight()) {
            ty = this.bot.getBattleFieldHeight() - (ty - this.bot.getBattleFieldHeight());
        }
        this.doFire(firePower, target, this.bot.getVectorAngle(this.bot.getX(), this.bot.getY(), tx, ty));
    }

    public void oscilateTarget(Enemy target, double firePower) {
        long time = (long)(target.distance / (20.0 - 3.0 * firePower));
        if ((time = (long)((double)time - (target.avgOscilTime - ((double)this.bot.getTime() - target.oscilTime)))) < 0L) {
            time = 0L;
        }
        time = (long)((double)time % target.avgOscilTime);
        double tx = (target.guessAvgX(time += this.bot.getTime()) + target.x) / 2.0;
        double ty = (target.guessAvgY(time) + target.y) / 2.0;
        if (tx < 0.0) {
            tx = -tx;
        } else if (tx > this.bot.getBattleFieldWidth()) {
            tx = this.bot.getBattleFieldWidth() - (tx - this.bot.getBattleFieldWidth());
        }
        if (ty < 0.0) {
            ty = -ty;
        } else if (ty > this.bot.getBattleFieldHeight()) {
            ty = this.bot.getBattleFieldHeight() - (ty - this.bot.getBattleFieldHeight());
        }
        double angle = this.bot.getVectorAngle(this.bot.getX(), this.bot.getY(), tx, ty);
        this.doFire(firePower, target, angle);
    }

    public double calculateFirePower(Enemy target) {
        int k = 600;
        if (this.bot.inCorner(target.x, target.y)) {
            k = 800;
        }
        double firePower = (double)k / target.distance;
        if (target.speed == 0.0) {
            firePower = 3.0;
        }
        if (target.distance < 400.0) {
            double angle = this.bot.getVectorAngle(this.bot.getX(), this.bot.getY(), target.x, target.y);
            double a = this.bot.normalize(target.head + Math.PI) - angle;
            if (a < 0.5 && a > -0.5) {
                firePower = 3.0;
            } else {
                a = target.head - angle;
                if (a < 0.5 && a > -0.5) {
                    firePower = 3.0;
                }
            }
        }
        if (target.energy < firePower) {
            firePower = target.energy / 3.0;
        }
        if (this.bot.getEnergy() - firePower < 1.0) {
            firePower = 0.1;
        }
        return firePower;
    }

    public void doFire(double firePower, Enemy target, double angle) {
        this.bot.setGunHeading(angle);
        if (this.bot.getEnergy() > 0.1 || target.energy == 0.0 && target.speed == 0.0) {
            this.bot.fire(firePower);
        }
    }
}

