/*
 * Decompiled with CFR 0.152.
 */
package pedersen.misc;

import pedersen.core.Constraints;
import pedersen.physics.SlopeFormula;
import pedersen.physics.StaticHeadingImpl;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticPositionImpl;
import pedersen.physics.StaticVector;
import pedersen.physics.StaticVectorImpl;

public class Arena {
    public static final Arena singleton = new Arena();
    public static final double north = 0.0;
    public static final double northEast = 0.7853981633974483;
    public static final double east = 1.5707963267948966;
    public static final double southEast = 2.356194490192345;
    public static final double south = Math.PI;
    public static final double southWest = 3.9269908169872414;
    public static final double west = 4.71238898038469;
    public static final double northWest = 5.497787143782138;
    public static final double minimumDistanceFromWall = 18.0;
    private final double absoluteMinX = 0.0;
    private final double absoluteMinY = 0.0;
    private final double minX = 18.0;
    private final double minY = 18.0;
    private double absoluteMaxX = 0.0;
    private double absoluteMaxY = 0.0;
    private double maxX = 0.0;
    private double maxY = 0.0;
    private StaticPosition center;

    private Arena() {
    }

    public static void init(double battleFieldWidth, double battleFieldHeight) {
        Arena.singleton.absoluteMaxX = battleFieldWidth;
        Arena.singleton.absoluteMaxY = battleFieldHeight;
        Arena.singleton.maxX = Arena.singleton.absoluteMaxX - 18.0;
        Arena.singleton.maxY = Arena.singleton.absoluteMaxY - 18.0;
        singleton.getClass();
        double d = (0.0 + Arena.singleton.absoluteMaxX) * 0.5;
        singleton.getClass();
        Arena.singleton.center = new StaticPositionImpl(d, (0.0 + Arena.singleton.absoluteMaxY) * 0.5);
    }

    public static boolean isInAbsoluteBoundary(StaticPosition position) {
        singleton.getClass();
        if (Constraints.isInRange(0.0, position.getX(), Arena.singleton.absoluteMaxX)) {
            singleton.getClass();
            if (Constraints.isInRange(0.0, position.getY(), Arena.singleton.absoluteMaxY)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isVehicleCenterInBoundary(StaticPosition position) {
        singleton.getClass();
        if (Constraints.isInRange(18.0, position.getX(), Arena.singleton.maxX)) {
            singleton.getClass();
            if (Constraints.isInRange(18.0, position.getY(), Arena.singleton.maxY)) {
                return true;
            }
        }
        return false;
    }

    private static double pythagorean(double r, double margin) {
        return Math.sqrt(r * r - margin * margin);
    }

    public static StaticPosition adjustOutOfBoundsTarget(StaticPosition chassisPosition, StaticPosition targetPosition) {
        StaticPosition adjustedPosition = targetPosition;
        if (!Arena.isVehicleCenterInBoundary(targetPosition)) {
            double x = targetPosition.getX();
            double y = targetPosition.getY();
            singleton.getClass();
            if (!Constraints.isInRange(18.0, x, Arena.singleton.maxX)) {
                singleton.getClass();
                if (!Constraints.isInRange(18.0, y, Arena.singleton.maxY)) {
                    double deltaY;
                    double d;
                    double d2;
                    singleton.getClass();
                    if (x < 18.0) {
                        singleton.getClass();
                        d2 = 18.0 - x;
                    } else {
                        d2 = x - Arena.singleton.maxX;
                    }
                    double deltaX = d2;
                    singleton.getClass();
                    if (y < 18.0) {
                        singleton.getClass();
                        d = 18.0 - y;
                    } else {
                        d = deltaY = y - Arena.singleton.maxY;
                    }
                    if (deltaX > deltaY) {
                        x = chassisPosition.getX() - (x - chassisPosition.getX());
                    } else {
                        y = chassisPosition.getY() - (y - chassisPosition.getY());
                    }
                }
            }
            double heading = chassisPosition.getBearing(targetPosition);
            double r = chassisPosition.getDistance(targetPosition);
            if (x > Arena.singleton.maxX) {
                x = Arena.singleton.maxX;
                double pythagorean = Arena.pythagorean(r, Arena.singleton.maxX - chassisPosition.getX());
                y = Constraints.isInRange(0.0, heading, 1.5707963267948966) ? chassisPosition.getY() + pythagorean : chassisPosition.getY() - pythagorean;
            } else {
                singleton.getClass();
                if (y < 18.0) {
                    singleton.getClass();
                    y = 18.0;
                    double d = chassisPosition.getY();
                    singleton.getClass();
                    double pythagorean = Arena.pythagorean(r, d - 18.0);
                    x = Constraints.isInRange(1.5707963267948966, heading, Math.PI) ? chassisPosition.getX() + pythagorean : chassisPosition.getX() - pythagorean;
                } else {
                    singleton.getClass();
                    if (x < 18.0) {
                        singleton.getClass();
                        x = 18.0;
                        double d = chassisPosition.getX();
                        singleton.getClass();
                        double pythagorean = Arena.pythagorean(r, d - 18.0);
                        y = Constraints.isInRange(Math.PI, heading, 4.71238898038469) ? chassisPosition.getY() - pythagorean : chassisPosition.getY() + pythagorean;
                    } else {
                        y = Arena.singleton.maxY;
                        double pythagorean = Arena.pythagorean(r, Arena.singleton.maxY - chassisPosition.getY());
                        x = Constraints.isInRange(0.0, heading, 1.5707963267948966) ? chassisPosition.getX() + pythagorean : chassisPosition.getX() - pythagorean;
                    }
                }
            }
            adjustedPosition = new StaticPositionImpl(x, y);
        }
        return adjustedPosition;
    }

    public static StaticPosition getWallIntercept(StaticPosition position, double heading, double velocity) {
        StaticPosition wallIntercept;
        if (heading == 0.0) {
            wallIntercept = new StaticPositionImpl(position.getX(), Arena.singleton.maxY);
        } else if (heading == Math.PI) {
            double d = position.getX();
            singleton.getClass();
            wallIntercept = new StaticPositionImpl(d, 18.0);
        } else if (heading == 1.5707963267948966) {
            wallIntercept = new StaticPositionImpl(Arena.singleton.maxX, position.getY());
        } else if (heading == 4.71238898038469) {
            singleton.getClass();
            wallIntercept = new StaticPositionImpl(18.0, position.getY());
        } else {
            SlopeFormula slope = new SlopeFormula(position, heading);
            if (velocity < 0.0) {
                heading = StaticHeadingImpl.getOpposedAngle(heading);
            }
            StaticPosition wallIntercept1 = Arena.getWallInterceptN(slope);
            StaticPosition wallIntercept2 = Arena.getWallInterceptS(slope);
            wallIntercept = Arena.getWallInterceptE(slope);
            if (wallIntercept1 == null) {
                wallIntercept1 = wallIntercept;
            } else if (wallIntercept2 == null) {
                wallIntercept2 = wallIntercept;
            }
            wallIntercept = Arena.getWallInterceptW(slope);
            if (wallIntercept1 == null) {
                wallIntercept1 = wallIntercept;
            } else if (wallIntercept2 == null) {
                wallIntercept2 = wallIntercept;
            }
            wallIntercept = wallIntercept1 != null && Constraints.areEqual(heading, position.getBearing(wallIntercept1)) ? wallIntercept1 : (wallIntercept2 != null && Constraints.areEqual(heading, position.getBearing(wallIntercept2)) ? wallIntercept2 : Arena.getCenter());
        }
        return wallIntercept;
    }

    private static StaticPosition getWallInterceptN(SlopeFormula slope) {
        StaticPositionImpl wallIntercept = null;
        double y = Arena.singleton.maxY;
        double x = slope.getFunctionOfY(y);
        singleton.getClass();
        if (Constraints.isInRange(18.0, x, Arena.singleton.maxX)) {
            wallIntercept = new StaticPositionImpl(x, y);
        }
        return wallIntercept;
    }

    private static StaticPosition getWallInterceptS(SlopeFormula slope) {
        StaticPositionImpl wallIntercept = null;
        singleton.getClass();
        double y = 18.0;
        double x = slope.getFunctionOfY(y);
        singleton.getClass();
        if (Constraints.isInRange(18.0, x, Arena.singleton.maxX)) {
            wallIntercept = new StaticPositionImpl(x, y);
        }
        return wallIntercept;
    }

    private static StaticPosition getWallInterceptE(SlopeFormula slope) {
        StaticPositionImpl wallIntercept = null;
        double x = Arena.singleton.maxX;
        double y = slope.getFunctionOfX(x);
        singleton.getClass();
        if (Constraints.isInRange(18.0, y, Arena.singleton.maxY)) {
            wallIntercept = new StaticPositionImpl(x, y);
        }
        return wallIntercept;
    }

    private static StaticPosition getWallInterceptW(SlopeFormula slope) {
        StaticPositionImpl wallIntercept = null;
        singleton.getClass();
        double x = 18.0;
        double y = slope.getFunctionOfX(x);
        singleton.getClass();
        if (Constraints.isInRange(18.0, y, Arena.singleton.maxY)) {
            wallIntercept = new StaticPositionImpl(x, y);
        }
        return wallIntercept;
    }

    public static StaticVector getVectorFromNearestWall(StaticPosition position, double magnitude) {
        double vectorHeading = 1.5707963267948966;
        double minDistance = position.getX() - Arena.getMinX();
        double distance = position.getY() - Arena.getMinY();
        if (distance < minDistance) {
            minDistance = distance;
            vectorHeading = 0.0;
        }
        if ((distance = Arena.getMaxX() - position.getX()) < minDistance) {
            minDistance = distance;
            vectorHeading = 4.71238898038469;
        }
        if ((distance = Arena.getMaxY() - position.getY()) < minDistance) {
            minDistance = distance;
            vectorHeading = Math.PI;
        }
        return new StaticVectorImpl(vectorHeading, magnitude);
    }

    public static StaticPosition getCenter() {
        return Arena.singleton.center;
    }

    public static double getAbsoluteMinX() {
        singleton.getClass();
        return 0.0;
    }

    public static double getAbsoluteMinY() {
        singleton.getClass();
        return 0.0;
    }

    public static double getAbsoluteMaxX() {
        return Arena.singleton.absoluteMaxX;
    }

    public static double getAbsoluteMaxY() {
        return Arena.singleton.absoluteMaxY;
    }

    public static double getMinX() {
        singleton.getClass();
        return 18.0;
    }

    public static double getMinY() {
        singleton.getClass();
        return 18.0;
    }

    public static double getMaxX() {
        return Arena.singleton.maxX;
    }

    public static double getMaxY() {
        return Arena.singleton.maxY;
    }
}

