/*
 * Decompiled with CFR 0.152.
 */
package catcat20.atom.utils;

import catcat20.atom.robot.BotState;
import catcat20.atom.utils.knn.TreeGFData;
import catcat20.jewel.iolite.utils.IUtils;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import robocode.Rules;
import robocode.util.Utils;

public class Wave
extends Point2D.Double {
    public Color color;
    public int shotCount;
    public long fireTime;
    public double bulletPower;
    public double distanceTraveled;
    public double directAngle;
    public int direction = 1;
    public String enName;
    public boolean isMeleeWave = false;
    public boolean isRealWave = true;
    public boolean rammerWave = false;
    public int ramTimeCount = 0;
    public BotState enState;
    public BotState prevEnState;
    public BotState myState;
    public BotState prevMyState;
    public double myLatVel;
    public double myDist10;
    public double myDist16;
    public double myDist30;
    public double myDist60;
    public double myDist120;
    public double myDirChangeTime;
    public double enDist16;
    public double enDist30;
    public double enDist60;
    public double enDist120;
    public double enDirChangeTime;
    public double enMeaWallAhead;
    public double enMeaWallReverse;
    public double[] preprocessedData;
    public double[] bins;
    public Wave back;
    public Wave next;
    public Wave tickBack;
    public Wave thisTickWave;
    public Wave tickNext;
    public double currentGF = 0.0;
    public ArrayList<Double> quickOffsets;
    public ArrayList<Double> quickWeights;
    public ArrayList<Double> quickPows;
    public ArrayList<TreeGFData> nearestNeighbors = null;

    public Wave(Point2D.Double pos) {
        super(pos.x, pos.y);
    }

    public Wave(double x, double y) {
        super(x, y);
    }

    public double bulletVelocity() {
        return Rules.getBulletSpeed((double)this.bulletPower);
    }

    public double firingAngle(double guessFactor) {
        return this.directAngle + guessFactor * (double)this.direction * this.maxEscapeAngle(this.bulletVelocity());
    }

    public double guessFactor(Point2D.Double targetLocation) {
        double bearingToTarget = IUtils.absoluteBearing(this, targetLocation);
        return this.guessFactor(bearingToTarget);
    }

    public double guessFactor(double bearingToTarget) {
        return this.guessAngle(bearingToTarget) / this.maxEscapeAngle(this.bulletVelocity());
    }

    public double guessAngle(Point2D.Double targetLocation) {
        double bearingToTarget = IUtils.absoluteBearing(this, targetLocation);
        return this.guessAngle(bearingToTarget);
    }

    public double guessAngle(double bearingToTarget) {
        return (double)this.direction * Utils.normalRelativeAngle((double)(bearingToTarget - this.directAngle));
    }

    private double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }
}

