/*
 * Decompiled with CFR 0.152.
 */
package divineomega.patternmatching;

import divineomega.DivineBot;
import divineomega.patternmatching.PatternMatchingItem;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class PatternMatchingManager {
    public static HashMap<String, ArrayList<PatternMatchingItem>> history = new HashMap();
    private static int chainLength = 7;
    private static int historyMaxSize = 500;
    public static Point2D targetPoint;
    public static Point2D targetPoint2;

    public static void addItem(String enemyName, double heading, double velocity) {
        ArrayList<PatternMatchingItem> enemyHistory = history.get(enemyName);
        if (enemyHistory == null) {
            enemyHistory = new ArrayList();
        }
        while (enemyHistory.size() > historyMaxSize) {
            enemyHistory.remove(0);
        }
        double headingDifference = 0.0;
        double velocityDifference = 0.0;
        if (enemyHistory.size() > 0) {
            PatternMatchingItem lastPatternMatchingItem = enemyHistory.get(enemyHistory.size() - 1);
            headingDifference = heading - lastPatternMatchingItem.heading;
            velocityDifference = velocity - lastPatternMatchingItem.velocity;
        }
        PatternMatchingItem newPatternMatchingItem = new PatternMatchingItem(heading, velocity, headingDifference, velocityDifference);
        enemyHistory.add(newPatternMatchingItem);
        history.put(enemyName, enemyHistory);
    }

    private static ArrayList<PatternMatchingItem> findBestItems(String enemyName, int numberOfItems, boolean compoundPrediction) {
        ArrayList<PatternMatchingItem> bestItems = new ArrayList<PatternMatchingItem>();
        int bestIndex = PatternMatchingManager.findBestIndex(enemyName, PatternMatchingManager.getLatestEnemyHistory(enemyName));
        if (bestIndex == -1) {
            return bestItems;
        }
        ArrayList<PatternMatchingItem> enemyHistory = history.get(enemyName);
        if (enemyHistory == null) {
            enemyHistory = new ArrayList();
        }
        if (compoundPrediction) {
            int x = 0;
            while (x < numberOfItems) {
                bestItems.add(enemyHistory.get(bestIndex + 1));
                ArrayList<PatternMatchingItem> patternMatchingItems = new ArrayList<PatternMatchingItem>();
                patternMatchingItems.addAll(PatternMatchingManager.getLatestEnemyHistory(enemyName));
                patternMatchingItems.addAll(bestItems);
                bestIndex = PatternMatchingManager.findBestIndex(enemyName, patternMatchingItems);
                ++x;
            }
        } else {
            int x = 0;
            while (x < numberOfItems) {
                int index = bestIndex + 1 + x;
                if (index <= enemyHistory.size() - 1) {
                    bestItems.add(enemyHistory.get(index));
                    ++x;
                    continue;
                }
                break;
            }
        }
        return bestItems;
    }

    private static int findBestIndex(String enemyName, ArrayList<PatternMatchingItem> patternMatchingItems) {
        ArrayList<PatternMatchingItem> enemyHistory = history.get(enemyName);
        if (enemyHistory == null) {
            enemyHistory = new ArrayList();
        }
        if (enemyHistory.size() <= chainLength) {
            return -1;
        }
        double lowestPmDifferenceTotal = Double.MAX_VALUE;
        int bestIndex = -1;
        int currentIndex = 0;
        for (PatternMatchingItem patternMatchingItem : enemyHistory) {
            if (currentIndex >= enemyHistory.size() - 1 - chainLength) break;
            double pmDifferenceTotal = 0.0;
            for (PatternMatchingItem latestPatternMatchingItem : patternMatchingItems) {
                pmDifferenceTotal += Math.abs(patternMatchingItem.velocityDifference - latestPatternMatchingItem.velocityDifference);
                pmDifferenceTotal += Math.abs(patternMatchingItem.headingDifference - latestPatternMatchingItem.headingDifference);
            }
            if (pmDifferenceTotal <= lowestPmDifferenceTotal) {
                lowestPmDifferenceTotal = pmDifferenceTotal;
                bestIndex = currentIndex;
            }
            ++currentIndex;
        }
        return bestIndex;
    }

    private static ArrayList<PatternMatchingItem> getLatestEnemyHistory(String enemyName) {
        ArrayList<PatternMatchingItem> enemyHistory = history.get(enemyName);
        ArrayList<PatternMatchingItem> latestEnemyHistory = new ArrayList<PatternMatchingItem>();
        if (enemyHistory == null || enemyHistory.size() <= chainLength) {
            return latestEnemyHistory;
        }
        int x = chainLength;
        while (x >= 0) {
            latestEnemyHistory.add(enemyHistory.get(enemyHistory.size() - 1 - x));
            --x;
        }
        return latestEnemyHistory;
    }

    public static ArrayList<Point2D> findBestPoints(String enemyName, int numberOfPoints, Point2D startingPosition, double startingHeading, double startingVelocity, boolean compoundPrediction) {
        ArrayList<Point2D> bestPoints = new ArrayList<Point2D>();
        if (startingPosition == null) {
            return bestPoints;
        }
        double newHeading = startingHeading;
        double newVelocity = startingVelocity;
        Point2D newPosition = startingPosition;
        ArrayList<PatternMatchingItem> bestItems = PatternMatchingManager.findBestItems(enemyName, numberOfPoints, compoundPrediction);
        for (PatternMatchingItem bestItem : bestItems) {
            newPosition = DivineBot.project(newPosition, newHeading += bestItem.headingDifference, newVelocity += bestItem.velocityDifference);
            bestPoints.add(new Point2D.Double(newPosition.getX(), newPosition.getY()));
        }
        return bestPoints;
    }

    public static void paint(Graphics g, String enemyName, Point2D startingPosition, double startingHeading, double startingVelocity) {
        if (startingPosition == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(startingPosition.getX(), startingPosition.getY());
        ArrayList<Point2D> bestPoints = PatternMatchingManager.findBestPoints(enemyName, 40, startingPosition, startingHeading, startingVelocity, false);
        for (Point2D bestPoint : bestPoints) {
            ((Path2D)path).lineTo(bestPoint.getX(), bestPoint.getY());
        }
        g2.draw(path);
        Path2D.Double path2 = new Path2D.Double();
        ((Path2D)path2).moveTo(startingPosition.getX(), startingPosition.getY());
        ArrayList<Point2D> bestPoints2 = PatternMatchingManager.findBestPoints(enemyName, 40, startingPosition, startingHeading, startingVelocity, true);
        for (Point2D bestPoint : bestPoints2) {
            ((Path2D)path2).lineTo(bestPoint.getX(), bestPoint.getY());
        }
        g2.draw(path2);
        if (targetPoint != null) {
            g.drawOval((int)targetPoint.getX() - 4, (int)targetPoint.getY() - 4, 8, 8);
        }
        if (targetPoint2 != null) {
            g.drawOval((int)targetPoint2.getX() - 4, (int)targetPoint2.getY() - 4, 8, 8);
        }
    }
}

