/*
 * Decompiled with CFR 0.152.
 */
package com.syncleus.robocode;

import robocode.ScannedRobotEvent;

class ScanPing
implements Comparable<ScanPing> {
    private ScannedRobotEvent enemyRobot = null;
    private double localHeadingRadians = 0.0;
    private double localX = 0.0;
    private double localY = 0.0;
    private int turn;

    public ScanPing(ScannedRobotEvent enemyRobot, double localHeadingRadians, double localX, double localY, int turn) {
        this.setEnemyRobot(enemyRobot);
        this.setLocalHeadingRadians(localHeadingRadians);
        this.setLocalX(localX);
        this.setTurn(turn);
    }

    public double getEnemyBearingAbsolute() {
        return this.localHeadingRadians + this.enemyRobot.getBearingRadians();
    }

    public double getEnemyX() {
        return this.localX + Math.sin(this.getEnemyBearingAbsolute()) * this.getEnemyRobot().getDistance();
    }

    public double getEnemyY() {
        return this.localY + Math.cos(this.getEnemyBearingAbsolute()) * this.getEnemyRobot().getDistance();
    }

    public int hashCode() {
        int currentHash = this.enemyRobot.hashCode();
        currentHash ^= (int)(this.localHeadingRadians * 10000.0);
        currentHash ^= (int)(this.localX * 10000.0);
        currentHash ^= (int)(this.localY * 10000.0);
        return currentHash ^= this.turn;
    }

    public boolean equals(Object compareWith) {
        if (compareWith instanceof ScanPing) {
            ScanPing scanCompare = (ScanPing)compareWith;
            if (this.enemyRobot.equals(scanCompare.enemyRobot) && this.localHeadingRadians == scanCompare.localHeadingRadians && this.localX == scanCompare.localX && this.localY == scanCompare.localY && this.turn == scanCompare.turn) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int compareTo(ScanPing compareWith) {
        return this.turn - compareWith.turn;
    }

    private void setEnemyRobot(ScannedRobotEvent enemyRobot) {
        if (enemyRobot == null) {
            throw new NullPointerException("enemyRobot can not be null");
        }
        this.enemyRobot = enemyRobot;
    }

    public ScannedRobotEvent getEnemyRobot() {
        return this.enemyRobot;
    }

    public double getLocalHeadingRadians() {
        return this.localHeadingRadians;
    }

    private void setLocalHeadingRadians(double localHeadingRadians) {
        this.localHeadingRadians = localHeadingRadians;
    }

    public double getLocalX() {
        return this.localX;
    }

    private void setLocalX(double localX) {
        this.localX = localX;
    }

    public double getLocalY() {
        return this.localY;
    }

    private void setLocalY(double localY) {
        this.localY = localY;
    }

    public int getTurn() {
        return this.turn;
    }

    private void setTurn(int turn) {
        this.turn = turn;
    }
}

