/*
 * Decompiled with CFR 0.152.
 */
package pez.mini;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.Condition;
import robocode.ScannedRobotEvent;

public class Gouldingi
extends AdvancedRobot {
    private static final double DEFAULT_DISTANCE = 600.0;
    private static final double WALL_MARGIN = 32.0;
    private static Point2D robotLocation = new Point2D.Double();
    private static Point2D oldLocation = new Point2D.Double();
    private static Point2D enemyLocation = new Point2D.Double();
    private static Point2D oldEnemyLocation = new Point2D.Double();
    private static Rectangle2D fieldRectangle;
    private static double enemyDistance;
    private static double enemyEnergy;
    private static double enemyAbsoluteBearing;
    private static double deltaBearing;
    private static double meanOffsetFactor;
    private static double[] meanAimFactor;
    private static int segment;
    private static double shots;
    private static double accumulatedAngle;
    private double enemyFirePower;
    private double maxRobotVelocity = 8.0;
    private int direction = 1;
    private long nextTime;
    private boolean doRam = false;

    public void run() {
        fieldRectangle = new Rectangle2D.Double(0.0, 0.0, this.getBattleFieldWidth(), this.getBattleFieldHeight());
        this.setColors(Color.gray, Color.yellow, Color.black);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        Bullet bullet;
        oldLocation.setLocation(robotLocation);
        robotLocation.setLocation(this.getX(), this.getY());
        oldEnemyLocation.setLocation(enemyLocation);
        enemyAbsoluteBearing = this.getHeading() + scannedRobotEvent.getBearing();
        enemyDistance = scannedRobotEvent.getDistance();
        this.toLocation(enemyAbsoluteBearing, enemyDistance, robotLocation, enemyLocation);
        double d = enemyEnergy - scannedRobotEvent.getEnergy();
        enemyEnergy = scannedRobotEvent.getEnergy();
        if (d >= 0.1 && d <= 3.0) {
            this.enemyFirePower = d;
        }
        double d2 = enemyDistance / (20.0 - 3.0 * this.enemyFirePower);
        if (Math.random() < 1.0 / this.maxRobotVelocity) {
            this.maxRobotVelocity = Math.random() * 24.0;
        }
        if (this.getTime() > this.nextTime && Math.random() < 0.5) {
            if (Math.random() < 0.5) {
                this.direction *= -1;
            }
            this.nextTime = this.getTime() + (long)(d2 * Math.random() * (1.582 - this.enemyFirePower / 4.2398));
        }
        this.doRam = enemyEnergy <= 0.25 && this.getEnergy() > enemyEnergy * 5.0 && this.getOthers() == 1;
        this.goTo(this.relativeDestination(5 * this.direction));
        this.setMaxVelocity(Math.abs(this.getTurnRemaining()) < 40.0 ? this.maxRobotVelocity : 0.1);
        deltaBearing = this.normalRelativeAngle(this.absoluteBearing(oldLocation, enemyLocation) - this.absoluteBearing(oldLocation, oldEnemyLocation));
        segment = this.getSegment(deltaBearing);
        this.aim();
        if (enemyEnergy > 0.0 && (this.getEnergy() > 0.2 || enemyDistance < 150.0) && (bullet = this.setFireBullet(Math.min(this.getEnergy() / 3.0, Math.min(enemyEnergy / 4.0, 3.0)))) != null) {
            this.addCustomEvent(new CheckUpdateFactors(bullet));
            shots += 1.0;
        }
        this.setTurnRadarLeftRadians(this.getRadarTurnRemaining());
    }

    public void onHitByBullet(BulletHitEvent bulletHitEvent) {
        this.nextTime = (long)((double)this.nextTime - (double)(this.nextTime - this.getTime()) * Math.random());
    }

    Point2D relativeDestination(double d) {
        Point2D.Double double_ = new Point2D.Double();
        double d2 = 1.05;
        if (this.doRam) {
            d2 = -1.1;
        } else if (enemyDistance > 600.0) {
            d2 = 1.0;
        }
        this.toLocation(enemyAbsoluteBearing + 180.0 + d, enemyDistance * d2, enemyLocation, double_);
        double d3 = robotLocation.distance(double_);
        this.translateInsideField(double_, 32.0);
        this.toLocation(this.absoluteBearing(robotLocation, double_), d3, robotLocation, double_);
        this.translateInsideField(double_, 32.0);
        if (robotLocation.distance(double_) < 0.6 * d3) {
            this.direction *= -1;
        }
        return double_;
    }

    private final void aim() {
        double d = robotLocation.distance(enemyLocation);
        double d2 = this.absoluteBearing(robotLocation, enemyLocation);
        d2 = Math.abs(deltaBearing) > 0.05 ? (d2 += deltaBearing * meanAimFactor[segment]) : (d2 += meanOffsetFactor);
        Point2D.Double double_ = new Point2D.Double();
        this.toLocation(d2, d, robotLocation, double_);
        d2 = this.absoluteBearing(robotLocation, double_);
        this.setTurnGunRight(this.normalRelativeAngle(d2 - this.getGunHeading()));
    }

    private final void goTo(Point2D point2D) {
        double d = robotLocation.distance(point2D);
        double d2 = this.normalRelativeAngle(this.absoluteBearing(robotLocation, point2D) - this.getHeading());
        if (Math.abs(d2) > 90.0) {
            d *= -1.0;
            d2 = d2 > 0.0 ? (d2 -= 180.0) : (d2 += 180.0);
        }
        this.setTurnRight(d2);
        this.setAhead(d);
    }

    private final void translateInsideField(Point2D point2D, double d) {
        point2D.setLocation(Math.max(d, Math.min(fieldRectangle.getWidth() - d, point2D.getX())), Math.max(d, Math.min(fieldRectangle.getHeight() - d, point2D.getY())));
    }

    private final void toLocation(double d, double d2, Point2D point2D, Point2D point2D2) {
        point2D2.setLocation(point2D.getX() + Math.sin(Math.toRadians(d)) * d2, point2D.getY() + Math.cos(Math.toRadians(d)) * d2);
    }

    private final double absoluteBearing(Point2D point2D, Point2D point2D2) {
        return Math.toDegrees(Math.atan2(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY()));
    }

    private final double normalRelativeAngle(double d) {
        d = Math.toRadians(d);
        return Math.toDegrees(Math.atan2(Math.sin(d), Math.cos(d)));
    }

    public double rollingAvg(double d, double d2, double d3, double d4) {
        return (d * Math.min(shots, d3) + d2 * d4) / (Math.min(shots, d3) + d4);
    }

    private final int getSegment(double d) {
        if (d < -0.25) {
            return 0;
        }
        if (d > 0.25) {
            return 2;
        }
        return 1;
    }

    static {
        meanAimFactor = new double[3];
    }

    class CheckUpdateFactors
    extends Condition {
        private long time;
        private double bulletVelocity;
        private double bulletPower;
        private double bearingDelta;
        private Point2D oldRLocation = new Point2D.Double();
        private Point2D oldELocation = new Point2D.Double();
        private double oldBearing;
        private int segment;

        public boolean test() {
            if (this.bulletVelocity * (double)(Gouldingi.this.getTime() - this.time) > this.oldRLocation.distance(enemyLocation) - 10.0) {
                double d = Gouldingi.this.absoluteBearing(this.oldRLocation, enemyLocation);
                double d2 = Gouldingi.this.normalRelativeAngle(d - this.oldBearing);
                meanOffsetFactor = Gouldingi.this.rollingAvg(meanOffsetFactor, d2, 20.0, this.bulletPower);
                if (Math.abs(this.bearingDelta) > 0.05) {
                    meanAimFactor[this.segment] = Gouldingi.this.rollingAvg(meanAimFactor[this.segment], d2 / this.bearingDelta, 55.0, this.bulletPower);
                }
                Gouldingi.this.removeCustomEvent(this);
            }
            return false;
        }

        public CheckUpdateFactors(Bullet bullet) {
            this.time = Gouldingi.this.getTime();
            this.bulletVelocity = bullet.getVelocity();
            this.bulletPower = bullet.getPower();
            this.bearingDelta = deltaBearing;
            this.oldRLocation.setLocation(robotLocation);
            this.oldELocation.setLocation(enemyLocation);
            this.oldBearing = Gouldingi.this.absoluteBearing(this.oldRLocation, this.oldELocation);
            this.segment = Gouldingi.this.getSegment(this.bearingDelta);
        }
    }
}

