/*
 * Decompiled with CFR 0.152.
 */
package pedersen.divination;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pedersen.core.Constraints;
import pedersen.core.Conversions;
import pedersen.core.Snapshot;
import pedersen.core.SnapshotHistory;
import pedersen.debug.GraphicalDebugger;
import pedersen.divination.CombatWave;
import pedersen.divination.FiringAngle;
import pedersen.divination.WaveData;
import pedersen.misc.Host;
import pedersen.misc.ShortestRoute;
import pedersen.opponent.Target;
import pedersen.physics.CircleFormula;
import pedersen.physics.Projection;
import pedersen.physics.StaticHeadingImpl;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticPositionImpl;
import pedersen.physics.StaticVector;
import pedersen.physics.WaveBase;
import pedersen.systems.DrivingMethodStandardImpl;
import pedersen.tactics.bot.BearingOffsetRange;
import pedersen.tactics.bot.WaveAnalysisBase;

public abstract class CombatWaveBase
extends WaveBase
implements CombatWave {
    protected final Target target;
    protected final List firingAngles = new ArrayList();
    protected final WaveData waveData;
    protected boolean isActive = true;
    private boolean isDebugMode = false;
    private static final double vehicleRadius = Math.sqrt(648.0);
    public static long totalFiringAngles = 0L;

    public CombatWaveBase(Target newTarget, StaticPosition firingPosition, double bulletVelocity, Snapshot targetPositionAtTimeOfAiming, long timeOfCreation) {
        super(firingPosition, bulletVelocity, timeOfCreation);
        this.target = newTarget;
        double originalBearingToTarget = firingPosition.getBearing(targetPositionAtTimeOfAiming);
        BearingOffsetRange rangeOfMotion = this.getBearingOffsetRange(this.getVictim(), timeOfCreation, originalBearingToTarget);
        this.waveData = WaveAnalysisBase.getWaveData(firingPosition, targetPositionAtTimeOfAiming, bulletVelocity, rangeOfMotion);
    }

    protected void registerHit(long time) {
        BearingOffsetRange bearingOffsetRange = this.getBearingOffsetRange(this.getVictim(), time);
        if (bearingOffsetRange != null) {
            this.waveData.addBearingOffsetRange(bearingOffsetRange);
        }
        Iterator iterator = this.firingAngles.iterator();
        while (iterator.hasNext()) {
            FiringAngle firingAngle = (FiringAngle)iterator.next();
            Line2D.Double bulletLineSegment = this.getNextTurnsLineSegment(firingAngle.getFiringAngle(), time);
            if (!Constraints.doesBulletIntersectRobot(this.target, bulletLineSegment)) continue;
            firingAngle.getTargetingStatistics().incrementFired();
            firingAngle.getTargetingStatistics().incrementHit();
            iterator.remove();
        }
    }

    protected void registerMiss() {
        Iterator iterator = this.firingAngles.iterator();
        while (iterator.hasNext()) {
            FiringAngle firingAngle = (FiringAngle)iterator.next();
            firingAngle.getTargetingStatistics().incrementFired();
            iterator.remove();
        }
        this.recordWave();
    }

    protected abstract void recordWave();

    public Line2D.Double getNextTurnsLineSegment(double angle, long time) {
        StaticPositionImpl a = new StaticPositionImpl(this, angle, this.getRadius(time));
        StaticPositionImpl b = new StaticPositionImpl(this, angle, this.getRadius(time + 1L));
        return Conversions.getLine2D(a, b);
    }

    public boolean isActive(long time) {
        SnapshotHistory targetPosition = this.getVictim();
        if (this.isActive) {
            double radius = this.getRadius(time);
            double distance = this.getDistance(targetPosition);
            if (this.isWaveBeyondRobotPosition(targetPosition, time)) {
                this.registerMiss();
                this.isActive = false;
            } else if (radius > distance - radius && this.threatensRobot(targetPosition, time)) {
                this.registerHit(time);
            }
        }
        return this.isActive;
    }

    public boolean isWaveBeyondRobotPosition(StaticPosition position, long time) {
        return this.getRadius(time) > this.getDistance(position) + vehicleRadius;
    }

    private boolean doesWaveIntersectRobot(StaticPosition robotPosition, long time) {
        return Conversions.getEllipse2DForWave(this, time).intersects(Conversions.getRectangle2DForRobot(robotPosition));
    }

    public boolean threatensRobot(StaticPosition robotPosition, long time) {
        return this.doesWaveIntersectRobot(robotPosition, time) || this.doesWaveIntersectRobot(robotPosition, time + 1L);
    }

    public BearingOffsetRange getBearingOffsetRange(StaticPosition robotPosition, long time) {
        BearingOffsetRange bearingOffsetRange = null;
        Rectangle2D.Double hitbox = Conversions.getRectangle2DForRobot(robotPosition);
        ArrayList pointsOfIntersection = new ArrayList();
        pointsOfIntersection.addAll(new CircleFormula(this, this.getRadius(time)).getPointsOfIntersection(hitbox));
        pointsOfIntersection.addAll(new CircleFormula(this, this.getRadius(time + 1L)).getPointsOfIntersection(hitbox));
        int i = 0;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        Iterator iterator = pointsOfIntersection.iterator();
        while (iterator.hasNext()) {
            ++i;
            StaticPosition position = (StaticPosition)iterator.next();
            double relativeBearingToPosition = StaticHeadingImpl.getRelativeAngle(this.waveData.originalBearingToTarget, this.getBearing(position));
            min = Math.min(min, relativeBearingToPosition);
            max = Math.max(max, relativeBearingToPosition);
        }
        if (i > 0) {
            bearingOffsetRange = new BearingOffsetRange(min, max);
        }
        return bearingOffsetRange;
    }

    public BearingOffsetRange getBearingOffsetRange(Snapshot victim, long time, double originalBearingToTarget) {
        double tangentHeading = StaticHeadingImpl.getTangentAngle(this.getBearing(victim));
        StaticPosition targetPosition = this.getCWPosition(victim, tangentHeading, time);
        tangentHeading = victim.getBearing(targetPosition);
        targetPosition = this.getCWPosition(victim, tangentHeading, time);
        double cw = StaticHeadingImpl.getRelativeAngle(originalBearingToTarget, this.getBearing(targetPosition));
        tangentHeading = StaticHeadingImpl.getOpposedAngle(StaticHeadingImpl.getTangentAngle(this.getBearing(victim)));
        targetPosition = this.getCCWPosition(victim, tangentHeading, time);
        tangentHeading = victim.getBearing(targetPosition);
        targetPosition = this.getCCWPosition(victim, tangentHeading, time);
        double ccw = StaticHeadingImpl.getRelativeAngle(originalBearingToTarget, this.getBearing(targetPosition));
        return new BearingOffsetRange(ccw, cw);
    }

    private StaticPosition getCWPosition(Snapshot victim, double tangentHeading, long time) {
        double initialBearingToCombatant = this.getBearing(victim);
        double bestBearingOffset = 0.0;
        StaticPosition bestPosition = victim;
        Projection projection = new Projection(victim);
        long i = time;
        while (this.getRadius(i) < this.getDistance(projection.getStaticPosition())) {
            double bearingOffset;
            StaticPositionImpl targetPosition = new StaticPositionImpl(projection.getStaticPosition(), tangentHeading, 50.0);
            StaticVector movementVector = DrivingMethodStandardImpl.operate(projection, (StaticPosition)targetPosition);
            StaticPosition initialPosition = projection.getStaticPosition();
            projection.setRelativeTargetHeading(movementVector.getHeading());
            projection.setAbsoluteTargetVelocity(movementVector.getVelocity());
            projection.project();
            StaticPosition finalPosition = projection.getStaticPosition();
            if (this.isDebugMode) {
                GraphicalDebugger.addRenderableLineSegmentRoundScope(initialPosition, finalPosition, Color.green);
            }
            if ((bearingOffset = StaticHeadingImpl.getRelativeAngle(initialBearingToCombatant, this.getBearing(projection.getStaticPosition()))) > bestBearingOffset) {
                bestPosition = projection.getStaticPosition();
                bestBearingOffset = bearingOffset;
            }
            ++i;
        }
        return bestPosition;
    }

    private StaticPosition getCCWPosition(Snapshot victim, double tangentHeading, long time) {
        double initialBearingToCombatant = this.getBearing(victim);
        double bestBearingOffset = 0.0;
        StaticPosition bestPosition = victim;
        Projection projection = new Projection(victim);
        long i = time;
        while (this.getRadius(i) < this.getDistance(projection.getStaticPosition())) {
            double bearingOffset;
            StaticPositionImpl targetPosition = new StaticPositionImpl(projection.getStaticPosition(), tangentHeading, 50.0);
            StaticVector movementVector = DrivingMethodStandardImpl.operate(projection, (StaticPosition)targetPosition);
            StaticPosition initialPosition = projection.getStaticPosition();
            projection.setRelativeTargetHeading(movementVector.getHeading());
            projection.setAbsoluteTargetVelocity(movementVector.getVelocity());
            projection.project();
            StaticPosition finalPosition = projection.getStaticPosition();
            if (this.isDebugMode) {
                GraphicalDebugger.addRenderableLineSegmentRoundScope(initialPosition, finalPosition, Color.green);
            }
            if ((bearingOffset = StaticHeadingImpl.getRelativeAngle(initialBearingToCombatant, this.getBearing(projection.getStaticPosition()))) < bestBearingOffset) {
                bestPosition = projection.getStaticPosition();
                bestBearingOffset = bearingOffset;
            }
            ++i;
        }
        return bestPosition;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setInactive() {
        this.isActive = false;
    }

    public boolean doesAnyFiringAngleInterceptRobot(StaticPosition robotPosition, long time, Color debugColor) {
        boolean bulletIntersectsRobot = false;
        Iterator firingAngles = this.getFiringAngleIterator();
        while (!bulletIntersectsRobot && firingAngles.hasNext()) {
            FiringAngle firingAngle = (FiringAngle)firingAngles.next();
            Line2D.Double bulletLineSegment = this.getNextTurnsLineSegment(firingAngle.getFiringAngle(), time);
            bulletIntersectsRobot = Constraints.doesBulletIntersectRobot(robotPosition, bulletLineSegment);
            if (debugColor == null) continue;
            GraphicalDebugger.addRenderableLineSegmentTurnScope(bulletLineSegment, debugColor);
        }
        return bulletIntersectsRobot;
    }

    public void debug() {
    }

    public void onPaint(Graphics2D console) {
        if (this.isLiveRound()) {
            long time = Host.singleton.getTurn();
            console.setColor(Color.cyan);
            GraphicalDebugger.singleton.drawMarker(console, this);
            double radius1 = this.getRadius(time - 1L);
            double radius2 = this.getRadius(time);
            double radius3 = this.getRadius(time + 1L);
            StaticPositionImpl ccw = new StaticPositionImpl(this, StaticHeadingImpl.getCompoundAngle(this.waveData.originalBearingToTarget, this.waveData.rangeOfMotion.min()), radius1);
            StaticPositionImpl cw = new StaticPositionImpl(this, StaticHeadingImpl.getCompoundAngle(this.waveData.originalBearingToTarget, this.waveData.rangeOfMotion.max()), radius1);
            StaticPositionImpl dot = new StaticPositionImpl(this, this.waveData.originalBearingToTarget, radius1);
            console.setColor(Color.darkGray);
            GraphicalDebugger.singleton.drawLine(console, this, dot);
            GraphicalDebugger.singleton.drawLine(console, this, ccw);
            GraphicalDebugger.singleton.drawLine(console, this, cw);
            GraphicalDebugger.singleton.drawRing(console, this, radius1);
            GraphicalDebugger.singleton.drawRing(console, this, radius2);
            GraphicalDebugger.singleton.drawRing(console, this, radius3);
            Iterator firingAngleIterator = this.getFiringAngleIterator();
            while (firingAngleIterator.hasNext()) {
                FiringAngle firingAngle = (FiringAngle)firingAngleIterator.next();
                console.setColor(Color.red);
                Line2D.Double bulletSegment = this.getNextTurnsLineSegment(firingAngle.getFiringAngle(), time);
                console.draw(bulletSegment);
            }
        }
        double step = 0.05;
        console.setColor(Color.darkGray);
        double i = step;
        while (i <= 1.0) {
            GraphicalDebugger.singleton.drawMarkerRing(console, ShortestRoute.getOriginalGuessFactorPosition(this, -i));
            GraphicalDebugger.singleton.drawMarkerRing(console, ShortestRoute.getOriginalGuessFactorPosition(this, i));
            i += step;
        }
    }

    public void addFiringAngle(FiringAngle firingAngle) {
        this.firingAngles.add(firingAngle);
        ++totalFiringAngles;
    }

    public Iterator getFiringAngleIterator() {
        return this.firingAngles.iterator();
    }

    public WaveData getWaveData() {
        return this.waveData;
    }

    public void setLiveRound() {
        this.waveData.setLiveRound();
    }

    public boolean isLiveRound() {
        return this.waveData.isLiveRound();
    }

    public boolean isTargetActive() {
        return this.target.isActive();
    }

    public Target getTarget() {
        return this.target;
    }
}

