/*
 * Decompiled with CFR 0.152.
 */
package rampancy.standard;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import rampancy.util.RRobotState;
import rampancy.util.RUtil;
import rampancy.util.data.kdTree.KDPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDefaultKDPoint
extends KDPoint {
    public static final int WRONG_POINT_TYPE = 1000000;
    public RRobotState enemyState;
    public double guessFactor;
    public static final Comparator<RDefaultKDPoint> VELOCITY_COMPARE = new Comparator<RDefaultKDPoint>(){

        @Override
        public int compare(RDefaultKDPoint s1, RDefaultKDPoint s2) {
            double res = s1.enemyState.velocity - s2.enemyState.velocity;
            return RUtil.sign(res);
        }
    };
    public static final Comparator<RDefaultKDPoint> LATERAL_VEL_COMPARE = new Comparator<RDefaultKDPoint>(){

        @Override
        public int compare(RDefaultKDPoint s1, RDefaultKDPoint s2) {
            double res = s1.enemyState.lateralVelocity - s2.enemyState.lateralVelocity;
            return RUtil.sign(res);
        }
    };
    public static final Comparator<RDefaultKDPoint> ADV_VEL_COMPARE = new Comparator<RDefaultKDPoint>(){

        @Override
        public int compare(RDefaultKDPoint s1, RDefaultKDPoint s2) {
            double res = s1.enemyState.advancingVelocity - s2.enemyState.advancingVelocity;
            return RUtil.sign(res);
        }
    };
    public static final Comparator<RDefaultKDPoint> DELTA_V_COMPARE = new Comparator<RDefaultKDPoint>(){

        @Override
        public int compare(RDefaultKDPoint s1, RDefaultKDPoint s2) {
            double res = s1.enemyState.deltaV - s2.enemyState.deltaV;
            return RUtil.sign(res);
        }
    };
    public static final Comparator<RDefaultKDPoint> HEADING_COMPARE = new Comparator<RDefaultKDPoint>(){

        @Override
        public int compare(RDefaultKDPoint s1, RDefaultKDPoint s2) {
            double res = s1.enemyState.heading - s2.enemyState.heading;
            return RUtil.sign(res);
        }
    };
    public static final Comparator<RDefaultKDPoint> DELTA_H_COMPARE = new Comparator<RDefaultKDPoint>(){

        @Override
        public int compare(RDefaultKDPoint s1, RDefaultKDPoint s2) {
            double res = s1.enemyState.deltaH - s2.enemyState.deltaH;
            return RUtil.sign(res);
        }
    };
    public static final Comparator<RDefaultKDPoint> TIME_SINCE_STOP_COMPARE = new Comparator<RDefaultKDPoint>(){

        @Override
        public int compare(RDefaultKDPoint s1, RDefaultKDPoint s2) {
            double res = s1.enemyState.timeSinceStop - s2.enemyState.timeSinceStop;
            return RUtil.sign(res);
        }
    };
    public static final Comparator<RDefaultKDPoint> TIME_SINCE_DIRECTION_CHANGE_COMPARE = new Comparator<RDefaultKDPoint>(){

        @Override
        public int compare(RDefaultKDPoint s1, RDefaultKDPoint s2) {
            double res = s1.enemyState.timeSinceDirectionChange - s2.enemyState.timeSinceDirectionChange;
            return RUtil.sign(res);
        }
    };
    public static final Comparator<RDefaultKDPoint> TIME_SINCE_VELOCITY_CHANGE = new Comparator<RDefaultKDPoint>(){

        @Override
        public int compare(RDefaultKDPoint s1, RDefaultKDPoint s2) {
            double res = s1.enemyState.timeSinceVelocityChange - s2.enemyState.timeSinceVelocityChange;
            return RUtil.sign(res);
        }
    };
    public static final Comparator<RDefaultKDPoint> DISTANCE_COMPARE = new Comparator<RDefaultKDPoint>(){

        @Override
        public int compare(RDefaultKDPoint s1, RDefaultKDPoint s2) {
            double res = s1.enemyState.distance - s2.enemyState.distance;
            return RUtil.sign(res);
        }
    };
    public static final Comparator<RDefaultKDPoint> DISTANCE_FROM_WALL_COMPARE = new Comparator<RDefaultKDPoint>(){

        @Override
        public int compare(RDefaultKDPoint s1, RDefaultKDPoint s2) {
            double res = s1.enemyState.distanceFromWall - s2.enemyState.distanceFromWall;
            return RUtil.sign(res);
        }
    };

    public RDefaultKDPoint(RRobotState state, double guessFactor) {
        this.enemyState = state.getCopy();
        this.guessFactor = guessFactor;
    }

    @Override
    public double distanceTo(KDPoint target) {
        if (target instanceof RDefaultKDPoint) {
            RDefaultKDPoint t = (RDefaultKDPoint)target;
            RRobotState state = t.enemyState;
            double dist = RUtil.square(this.enemyState.lateralVelocity - state.lateralVelocity);
            dist += RUtil.square(this.enemyState.advancingVelocity - state.advancingVelocity);
            dist += RUtil.square(this.enemyState.deltaH - state.deltaH);
            dist += RUtil.square(this.enemyState.velocity - state.velocity);
            dist += RUtil.square(this.enemyState.distanceFromWallCategory * 2 - state.distanceFromWallCategory * 2);
            return dist += RUtil.square(this.enemyState.timeSinceDirectionChange - state.timeSinceDirectionChange);
        }
        return 1000000.0;
    }

    public static List<Comparator<RDefaultKDPoint>> getComparators() {
        ArrayList<Comparator<RDefaultKDPoint>> comparators = new ArrayList<Comparator<RDefaultKDPoint>>();
        comparators.add(VELOCITY_COMPARE);
        comparators.add(LATERAL_VEL_COMPARE);
        comparators.add(DELTA_H_COMPARE);
        comparators.add(DISTANCE_FROM_WALL_COMPARE);
        comparators.add(TIME_SINCE_DIRECTION_CHANGE_COMPARE);
        comparators.add(ADV_VEL_COMPARE);
        return comparators;
    }
}

