/*
 * Decompiled with CFR 0.152.
 */
package ender;

import ender.GameStatus;
import ender.MovePredictor;
import ender.ScanStatus;
import ender.Wave;
import ender.WaveManager;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class EnderRobot
extends AdvancedRobot {
    static final double RADAR_FACTOR = 2.0;
    static final int ENEMY_BUFFER = 3000;
    static final double SQRT2 = Math.sqrt(2.0);
    private WaveManager mWaveManager;
    private double mTanksize;
    private double mBfWidth;
    private double mBfHeight;
    private double mMinDistanceToWall;
    public Point2D.Double _myLocation;
    public static Rectangle2D.Double _fieldRect = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
    public static double WALL_STICK = 160.0;

    public void run() {
        this.mTanksize = this.getHeight();
        this.mBfWidth = this.getBattleFieldWidth();
        this.mBfHeight = this.getBattleFieldHeight();
        this.mWaveManager = new WaveManager();
        this.mMinDistanceToWall = this.mTanksize / 2.0 * SQRT2;
        this._myLocation = new Point2D.Double();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setColors(Color.orange, Color.white, Color.cyan, Color.pink, Color.green);
        while (true) {
            if (this.getRadarTurnRemaining() == 0.0) {
                this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
            }
            this.execute();
            this._myLocation.setLocation(this.getX(), this.getY());
            this.mWaveManager.update(this._myLocation, this.getHeadingRadians(), this.getVelocity(), this.getTime());
            this.doSurfing();
            this.doGun();
        }
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        ScanStatus status = new ScanStatus((Point2D.Double)this._myLocation.clone(), this.getHeadingRadians(), event.getHeadingRadians(), event.getDistance(), event.getBearingRadians(), this.getEnergy(), event.getEnergy(), this.getVelocity(), event.getVelocity(), this.getTime());
        GameStatus.instance().push(status, this.getTime());
        double radarturn = Utils.normalRelativeAngle((double)(event.getBearingRadians() + this.getHeadingRadians() - this.getRadarHeadingRadians()));
        this.setTurnRadarRightRadians(2.0 * radarturn);
        this.energyAnalysis();
    }

    public void onHitByBullet(HitByBulletEvent event) {
        Point2D.Double hitBulletLocation = new Point2D.Double(event.getBullet().getX(), event.getBullet().getY());
        Wave wave = this.mWaveManager.getHit(hitBulletLocation, event.getVelocity());
        if (wave == null) {
            System.out.println("wave no controlada!");
            return;
        }
        System.out.println("Ouch!");
        MovePredictor.instance().updateHit(wave, this.getTime(), this.getHeadingRadians(), this.getVelocity());
        this.mWaveManager.remove(wave);
    }

    public void onPaint(Graphics2D graphics) {
        graphics.setColor(Color.yellow);
        this.mWaveManager.onPaint(graphics);
    }

    private double distance(double v) {
        return v;
    }

    private double angle(double v) {
        return 20.0 - 0.75 * Math.abs(v);
    }

    private void energyAnalysis() {
        if (GameStatus.instance().size() < 2) {
            return;
        }
        ScanStatus status = GameStatus.instance().get(this.getTime());
        ScanStatus previousstatus = GameStatus.instance().get(this.getTime() - 1L);
        if (status.getAttr(7) >= previousstatus.getAttr(7)) {
            return;
        }
        if (this.borderCrash(previousstatus)) {
            System.out.println("Pared!");
            return;
        }
        this.mWaveManager.pushWave(status.getLocation(1), 20.0 - 3.0 * (previousstatus.getAttr(7) - status.getAttr(7)), this.getTime());
        System.out.println("fire!");
    }

    private boolean borderCrash(ScanStatus position) {
        return false;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!_fieldRect.contains(EnderRobot.project(botLocation, angle, WALL_STICK))) {
            angle += (double)orientation * 0.05;
        }
        return angle;
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(100.0);
        }
    }

    public Point2D.Double predictPosition(Wave surfWave, int direction) {
        Point2D.Double predictedPosition = (Point2D.Double)this._myLocation.clone();
        double predictedVelocity = this.getVelocity();
        double predictedHeading = this.getHeadingRadians();
        int counter = 0;
        boolean intercepted = false;
        do {
            double moveAngle = this.wallSmoothing(predictedPosition, EnderRobot.absoluteBearing(surfWave.getCenter(), predictedPosition) + (double)direction * 1.5707963267948966, direction) - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            moveAngle = Utils.normalRelativeAngle((double)moveAngle);
            double maxTurning = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + EnderRobot.limit(-maxTurning, moveAngle, maxTurning)));
            predictedVelocity += predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir;
            predictedVelocity = EnderRobot.limit(-8.0, predictedVelocity, 8.0);
            predictedPosition = EnderRobot.project(predictedPosition, predictedHeading, predictedVelocity);
            ++counter;
            if (!(predictedPosition.distance(surfWave.getCenter()) < surfWave.getDistance() + (double)counter * surfWave.getSpeed() + surfWave.getSpeed())) continue;
            intercepted = true;
        } while (!intercepted && counter < 500);
        return predictedPosition;
    }

    public static int getFactorIndex(Wave ew, Point2D.Double targetLocation) {
        return 0;
    }

    public void logHit(Wave ew, Point2D.Double targetLocation) {
    }

    public double checkDanger(Wave surfWave, int direction) {
        return Math.random();
    }

    public void doSurfing() {
        Wave surfWave = this.mWaveManager.getQuickestWave(this._myLocation);
        if (surfWave == null) {
            return;
        }
        double dangerLeft = this.checkDanger(surfWave, -1) + MovePredictor.instance().getPrediction(surfWave, this._myLocation, -this.getVelocity(), this.getHeadingRadians(), this.getTime());
        double dangerRight = this.checkDanger(surfWave, 1) + MovePredictor.instance().getPrediction(surfWave, this._myLocation, this.getVelocity(), this.getHeadingRadians(), this.getTime());
        double goAngle = GameStatus.instance().get(this.getTime()).getAttr(4);
        goAngle = EnderRobot.absoluteBearing(surfWave.getCenter(), this._myLocation);
        goAngle = dangerLeft < dangerRight ? this.wallSmoothing(this._myLocation, goAngle - 1.5707963267948966, -1) : this.wallSmoothing(this._myLocation, goAngle + 1.5707963267948966, 1);
        EnderRobot.setBackAsFront(this, goAngle);
    }

    public Point2D.Double guessPosition(long when, long time) {
        ScanStatus cur = GameStatus.instance().get(time);
        ScanStatus pre = GameStatus.instance().get(time - 1L);
        if (cur == null || pre == null) {
            return new Point2D.Double();
        }
        double diff = when - time;
        double changehead = cur.getAttr(3) - pre.getAttr(3);
        double speed = cur.getAttr(9);
        double heading = cur.getAttr(3);
        double x = cur.getLocation((int)1).x;
        double y = cur.getLocation((int)1).y;
        double radius = speed / changehead;
        double tothead = diff * changehead;
        double newY = y + Math.sin(heading + tothead) * radius - Math.sin(heading) * radius;
        double newX = x + Math.cos(heading) * radius - Math.cos(heading + tothead) * radius;
        return new Point2D.Double(newX, newY);
    }

    private void doGun() {
        long currentTime = this.getTime();
        long time = this.getTime();
        int firePower = 2;
        ScanStatus status = GameStatus.instance().get(currentTime);
        while (status == null && currentTime > 1L) {
            status = GameStatus.instance().get(--currentTime);
        }
        if (status == null) {
            return;
        }
        Point2D.Double p = status.getLocation(1);
        int i = 0;
        while (i < 5) {
            long nextTime = (int)Math.round(this.getrange(this.getX(), this.getY(), p.x, p.y) / (double)(20 - 3 * firePower));
            time = this.getTime() + nextTime;
            p = this.guessPosition(time, currentTime);
            ++i;
        }
        double gunOffset = this.getGunHeadingRadians() - (1.5707963267948966 - Math.atan2(p.y - this.getY(), p.x - this.getX()));
        this.setTurnGunLeftRadians(this.normaliseBearing(gunOffset));
        this.fire(firePower);
    }

    double normaliseBearing(double ang) {
        if (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    public double getrange(double x1, double y1, double x2, double y2) {
        double x = x2 - x1;
        double y = y2 - y1;
        double h = Math.sqrt(x * x + y * y);
        return h;
    }
}

