/*
 * Decompiled with CFR 0.152.
 */
package execution;

import execution.MessageRouter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import sim.Bot;
import sim.Wave;

public class Message
implements Serializable {
    private static final long serialVersionUID = -5021613031544637814L;
    public String subject;
    public Kind type;
    public long time;
    private Map<String, Object> _data = new HashMap<String, Object>(3);
    private MessageRouter _router;

    public void setRouter(MessageRouter router) {
        this._router = router;
    }

    public Object get(String identifier) {
        return this._data.get(identifier);
    }

    public Message about(String subject) {
        this.subject = subject;
        return this;
    }

    public Message about(Wave subject) {
        return this.about(subject.identifier);
    }

    public Message about(Bot subject) {
        return this.about(subject.Name);
    }

    public Message at(long time) {
        this.time = time;
        return this;
    }

    public Message set(String identifier, Object data) {
        this._data.put(identifier, data);
        return this;
    }

    public void send() {
        this._router.Send(this);
    }

    public Message respondWith(Kind type) {
        return this._router.prepare(type);
    }

    public void Reset() {
        this._data.clear();
        this.subject = null;
        this.type = Kind.None;
        this.time = 0L;
    }

    public static enum Kind {
        None,
        PreUpdate,
        Update,
        SkippedTurn,
        OnPaint,
        PaintEnabled,
        PaintDisabled,
        ScannedEnemy,
        DiscoveredEnemy,
        LostTrackOfEnemy,
        BattleStarted,
        BattleEnded,
        RoundStarted,
        RoundEnded,
        Win,
        EnemyWaveCreated,
        EnemyHeatWaveCreated,
        EnemyHeatWaveRemoved,
        EnemyWaveNeutralized,
        EnemyWaveIntersected,
        EnemyWaveCompleted,
        SelfWaveCreated,
        SelfWaveNeutralized,
        SelfWaveIntersected,
        SelfWaveCompleted,
        DamagedEnemy,
        TookDamage,
        BulletCollision,
        RobotCollision,
        WallCollision,
        EnemyDestroyed,
        DestroyedByEnemy;

    }
}

