/*
 * Decompiled with CFR 0.152.
 */
package pedersen;

import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Queue;
import pedersen.core.Foundation;
import pedersen.debug.renderable.Viewport;
import pedersen.divination.analysis.AnalysisConfiguration;
import pedersen.divination.analysis.AnalysisMethod;
import pedersen.divination.segmentation.Segmentation;
import pedersen.divination.segmentation.Segmenter;
import pedersen.movement.MovementMethod;
import pedersen.movement.absolute.MovementMethodRandomPointImpl;
import pedersen.movement.vectorsum.MovementMethodTangoImpl;
import pedersen.opponent.Target;
import pedersen.systems.FireControl;
import pedersen.systems.FireControlStandard;
import pedersen.targeting.TargetingMethod;
import pedersen.targeting.predictive.TargetingMethodCircularImpl;
import pedersen.targeting.predictive.TargetingMethodDeadOnImpl;
import pedersen.targeting.predictive.TargetingMethodLinearImpl;
import pedersen.targeting.predictive.TargetingMethodLinearMeanImpl;
import pedersen.targeting.predictive.TargetingMethodPartialLinearImpl;
import pedersen.targeting.statistical.TargetingMethodBearingOffsetImpl;

public final class Hubris
extends Foundation {
    private static Queue<MovementMethod> idleMovementMethods = Hubris.getIdleMovementMethods();
    private static Queue<MovementMethod> meleeMovementMethods = Hubris.getMeleeMovementMethods();
    private static final Color chassis = new Color(100, 88, 73);
    private static final Color turret = Color.white;
    private static final Color radar = new Color(194, 174, 140);

    public Hubris() {
        super(chassis, turret, radar);
    }

    @Override
    public void run() {
        this.init();
        super.run();
    }

    protected void init() {
    }

    @Override
    public Queue<MovementMethod> getMovementMethods(int opponentCount) {
        Queue<MovementMethod> movementMethods = null;
        movementMethods = opponentCount == 0 ? idleMovementMethods : (opponentCount == 1 ? idleMovementMethods : meleeMovementMethods);
        return movementMethods;
    }

    @Override
    public Queue<MovementMethod> getMovementMethods() {
        LinkedList<MovementMethod> movementMethods = new LinkedList<MovementMethod>();
        movementMethods.add(MovementMethodRandomPointImpl.getInstance());
        return movementMethods;
    }

    @Override
    public Iterable<TargetingMethod> getOutboundTargetingMethods(Target target) {
        ArrayList<TargetingMethod> targetingMethods = new ArrayList<TargetingMethod>();
        targetingMethods.add(new TargetingMethodDeadOnImpl());
        targetingMethods.add(new TargetingMethodLinearImpl());
        targetingMethods.add(new TargetingMethodCircularImpl());
        targetingMethods.add(new TargetingMethodLinearMeanImpl());
        targetingMethods.add(new TargetingMethodPartialLinearImpl());
        targetingMethods.add(new TargetingMethodBearingOffsetImpl(target.assignDefensiveWaveAnalysis(new Segmenter(new AnalysisConfiguration(AnalysisMethod.MOST_VISITED, 1.0, Viewport.LEFT_ONE), EnumSet.of(Segmentation.LATERAL_7, Segmentation.CLOSING_7)))));
        targetingMethods.add(new TargetingMethodBearingOffsetImpl(target.assignDefensiveWaveAnalysis(new Segmenter(new AnalysisConfiguration(AnalysisMethod.MOST_VISITED, 1.0, Viewport.LEFT_ONE), EnumSet.of(Segmentation.LATERAL_7, Segmentation.CLOSING_7, Segmentation.WALL_CW, Segmentation.WALL_CC)))));
        return targetingMethods;
    }

    @Override
    public Iterable<TargetingMethod> getInboundTargetingMethods(Target target) {
        ArrayList<TargetingMethod> targetingMethods = new ArrayList<TargetingMethod>();
        targetingMethods.add(new TargetingMethodDeadOnImpl());
        targetingMethods.add(new TargetingMethodLinearImpl());
        targetingMethods.add(new TargetingMethodCircularImpl());
        return targetingMethods;
    }

    @Override
    public FireControl getFireControl() {
        return new FireControlStandard();
    }

    private static Queue<MovementMethod> getIdleMovementMethods() {
        LinkedList<MovementMethod> movementMethods = new LinkedList<MovementMethod>();
        movementMethods.add(MovementMethodRandomPointImpl.getInstance());
        return movementMethods;
    }

    private static Queue<MovementMethod> getMeleeMovementMethods() {
        LinkedList<MovementMethod> movementMethods = new LinkedList<MovementMethod>();
        movementMethods.add(MovementMethodTangoImpl.getInstance());
        return movementMethods;
    }
}

