/*
 * Decompiled with CFR 0.152.
 */
package pedersen.core;

import pedersen.physics.Direction;
import pedersen.physics.Distance;
import pedersen.physics.HasDirection;
import pedersen.physics.HasPosition;
import pedersen.physics.Position;
import pedersen.physics.Snapshot;
import pedersen.physics.Vehicle;
import pedersen.physics.constant.DirectionImpl;

public class GameState
implements HasPosition {
    private static GameState singleton = new GameState();
    private String name;
    private int rounds;
    private double gunCoolingRate;
    private Snapshot snapshot = null;
    private int activeEnemyCount = 0;
    private double gunHeat = 30.0;
    private double scannerFacing = 0.0;
    private double turretFacing = 0.0;
    private int round = Integer.MIN_VALUE;
    private long turn = Long.MIN_VALUE;
    private long turnBefore = Long.MIN_VALUE;
    private long turnAfter = Long.MIN_VALUE;
    private double persistentRandom = 0.0;

    private GameState() {
    }

    public static GameState getInstance() {
        return singleton;
    }

    public boolean isFirstRound() {
        return this.round == 0;
    }

    public boolean isLastRound() {
        return this.round == this.rounds - 1;
    }

    public boolean isFirstTurn() {
        return this.turn == 0L;
    }

    public boolean isDisabled() {
        return this.snapshot.getEnergy().energy() == 0.0;
    }

    public boolean isGunCool() {
        return !this.isDisabled() && this.gunHeat == 0.0;
    }

    public boolean isGunCool(long turnFired, double firepower) {
        double heat = 1.0 + firepower * 0.2;
        double cool = this.gunCoolingRate * (double)(this.snapshot.getTime() - turnFired);
        return heat <= cool;
    }

    public boolean isEveryoneDead() {
        return this.activeEnemyCount == 0;
    }

    public boolean isInDuelMode() {
        return this.activeEnemyCount == 1;
    }

    public Position getRelativePosition(double bearing, double distance) {
        return this.snapshot.getPosition().addVector((HasDirection)this.snapshot.getDirection().addRadians(bearing), distance);
    }

    public Distance getDistance(HasPosition other) {
        return this.snapshot.getPosition().getDistance(other);
    }

    Vehicle getChassis() {
        return this.snapshot.getVehicle();
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public double getGunCoolingRate() {
        return this.gunCoolingRate;
    }

    public void setGunCoolingRate(double gunCoolingRate) {
        this.gunCoolingRate = gunCoolingRate;
    }

    public double getGunHeat() {
        return this.gunHeat;
    }

    public void setGunHeat(double gunHeat) {
        this.gunHeat = gunHeat;
    }

    public double getScannerFacing() {
        return this.scannerFacing;
    }

    public void setScannerFacing(double scannerFacing) {
        this.scannerFacing = scannerFacing;
    }

    public double getTurretFacing() {
        return this.turretFacing;
    }

    public void setTurretFacing(double turretFacing) {
        this.turretFacing = turretFacing;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRounds(int rounds) {
        this.rounds = rounds;
    }

    public void setActiveEnemyCount(int activeEnemyCount) {
        this.activeEnemyCount = activeEnemyCount;
    }

    public final String getName() {
        return this.name;
    }

    public final long getRounds() {
        return this.rounds;
    }

    public final int getActiveEnemyCount() {
        return this.activeEnemyCount;
    }

    public Direction getScannerHeading() {
        return new DirectionImpl(this.scannerFacing);
    }

    public Direction getTurretHeading() {
        return new DirectionImpl(this.turretFacing);
    }

    public void nextPersistentRandom() {
        this.persistentRandom = Math.random();
    }

    public double getPersistentRandom() {
        return this.persistentRandom;
    }

    public void setSnapshot(Snapshot snapshot) {
        this.snapshot = snapshot;
        this.round = snapshot.getRound();
        this.turn = snapshot.getTime();
        this.turnBefore = this.turn - 1L;
        this.turnAfter = this.turn + 1L;
    }

    @Override
    public Position getPosition() {
        return this.snapshot.getPosition();
    }

    public int getRound() {
        return this.round;
    }

    public long getTurn() {
        return this.turn;
    }

    public long getTurnBefore() {
        return this.turnBefore;
    }

    public long getTurnAfter() {
        return this.turnAfter;
    }
}

