/*
 * Decompiled with CFR 0.152.
 */
package pedersen.targeting;

import pedersen.core.Combatant;
import pedersen.core.Competitor;
import pedersen.debug.Debuggable;
import pedersen.debug.DebuggableBase;
import pedersen.divination.CombatWave;
import pedersen.divination.FiringSolution;
import pedersen.divination.TargetAnalysis;
import pedersen.divination.WaveInboundImpl;
import pedersen.divination.WaveOutboundImpl;
import pedersen.physics.Direction;
import pedersen.physics.Distance;
import pedersen.physics.Position;
import pedersen.physics.Velocity;
import pedersen.targeting.predictive.TargetingMethodDeadOnImpl;
import pedersen.util.Arena;
import pedersen.util.Constraints;
import pedersen.util.TargetingStatistics;

public interface TargetingMethod
extends Debuggable {
    public static final TargetingMethod zero = new TargetingMethodDeadOnImpl();

    public FiringSolution getFiringSolution(WaveOutboundImpl var1, TargetAnalysis var2, Competitor var3);

    public FiringSolution getFiringSolution(WaveInboundImpl var1, TargetAnalysis var2);

    public static abstract class TargetingMethodBase
    extends DebuggableBase
    implements TargetingMethod {
        protected final TargetingStatistics targetingStatistics = new TargetingStatistics();

        @Override
        public FiringSolution getFiringSolution(WaveOutboundImpl wave, TargetAnalysis targetAnalysis, Competitor target) {
            return this.getFiringSolution(wave, targetAnalysis, target, 1L, 0);
        }

        @Override
        public FiringSolution getFiringSolution(WaveInboundImpl wave, TargetAnalysis targetAnalysis) {
            return this.getFiringSolution(wave, targetAnalysis, Combatant.getCombatant(), 0L, 2);
        }

        protected abstract FiringSolution getFiringSolution(CombatWave var1, TargetAnalysis var2, Competitor var3, long var4, int var6);

        public double getSuccessRate(CombatWave wave) {
            return this.targetingStatistics.getSuccessRate();
        }

        @Override
        public String description() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getClass().getSimpleName());
            buffer.append(" ").append(this.targetingStatistics.description());
            return buffer.toString();
        }
    }

    public static abstract class TargetingMethodBasePredictive
    extends TargetingMethodBase {
        protected Position firingPosition = null;
        protected Competitor target;
        protected Position projectedTargetPosition = null;
        protected double velocity = 0.0;
        protected double heading = 0.0;
        protected double rateOfHeadingChange = 0.0;
        private static final int maxElapsedTime = 100;

        protected abstract boolean init();

        @Override
        protected FiringSolution getFiringSolution(CombatWave wave, TargetAnalysis targetAnalysis, Competitor target, long delay, int history) {
            FiringSolution firingSolution = null;
            this.firingPosition = wave.getPosition();
            this.target = target;
            this.projectedTargetPosition = this.target.getHistoricalSnapshot(history).getVehicle().getPosition();
            Velocity bulletVelocity = wave.getVelocity();
            if (this.init()) {
                int i = 0;
                while ((long)i < delay) {
                    this.project();
                    ++i;
                }
                int timeToTarget = 1;
                while (timeToTarget <= 100 && firingSolution == null && Arena.singleton.isVehicleCenterInBoundary(this.projectedTargetPosition)) {
                    Distance distanceToTarget = this.firingPosition.getDistance(this.projectedTargetPosition);
                    if (TargetingMethodBasePredictive.doesBulletIntersectTargetMidpoint(distanceToTarget, bulletVelocity, timeToTarget)) {
                        Direction bearingToTarget = this.firingPosition.getBearing(this.projectedTargetPosition);
                        firingSolution = new FiringSolution(bearingToTarget, this.targetingStatistics);
                    }
                    this.project();
                    ++timeToTarget;
                }
            }
            return firingSolution;
        }

        private boolean project() {
            this.heading += this.rateOfHeadingChange;
            this.projectedTargetPosition = this.projectedTargetPosition.addVector(this.heading, this.velocity);
            return true;
        }

        public static boolean doesBulletIntersectTargetMidpoint(Distance distanceToTarget, Velocity bulletVelocity, int timeToTarget) {
            return Constraints.isInRange(bulletVelocity.velocity() * (double)(timeToTarget - 1), distanceToTarget.distance(), bulletVelocity.velocity() * (double)timeToTarget);
        }
    }
}

