/*
 * Decompiled with CFR 0.152.
 */
package pedersen.util;

import pedersen.physics.Direction;
import pedersen.physics.Energy;
import pedersen.physics.Firepower;
import pedersen.physics.HasDirection;
import pedersen.physics.HasEnergy;
import pedersen.physics.HasFirepower;
import pedersen.physics.HasVelocity;
import pedersen.physics.Radius;
import pedersen.physics.Velocity;
import pedersen.physics.constant.DirectionImpl;
import pedersen.physics.constant.EnergyImpl;
import pedersen.physics.constant.FirepowerImpl;
import pedersen.physics.constant.RadiusImpl;
import pedersen.physics.constant.VelocityImpl;
import pedersen.util.BaseConversions;

public class Conversions
extends BaseConversions {
    public static Velocity getBulletVelocityFromFirepower(HasFirepower firepower) {
        return new VelocityImpl(BaseConversions.getBulletVelocityFromFirepower(firepower.getFirepower().firepower()));
    }

    public static Firepower getFirepowerFromBulletVelocity(HasVelocity velocity) {
        return new FirepowerImpl(BaseConversions.getFirepowerFromBulletVelocity(velocity.getVelocity().velocity()));
    }

    public static Direction getAbsMaxTurnRateFromVelocity(HasVelocity velocity) {
        return new DirectionImpl(BaseConversions.getAbsMaxTurnRateFromVelocity(velocity.getVelocity().velocity()));
    }

    public static Velocity getAbsMaxVelocityFromTurnRate(HasDirection turnRate) {
        return new VelocityImpl(BaseConversions.getAbsMaxVelocityFromTurnRate(turnRate.getDirection().getAbsoluteRadians()));
    }

    public static Radius getMinTurnRadiusFromVelocity(HasVelocity velocity) {
        return new RadiusImpl(BaseConversions.getMinTurnRadiusFromVelocity(velocity.getVelocity().velocity()));
    }

    public static Energy getEnergyRewardFromFirepower(HasFirepower firepower) {
        return new EnergyImpl(BaseConversions.getEnergyRewardFromFirepower(firepower.getFirepower().firepower()));
    }

    public static Firepower getFirepowerFromEnergyReward(HasEnergy energy) {
        return new FirepowerImpl(BaseConversions.getFirepowerFromEnergyReward(energy.getEnergy().energy()));
    }
}

