/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import pa3k.BulletTracking;
import pa3k.Log;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.RobotModule;
import pa3k.Tracking;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.util.Utils;

public abstract class Gun
extends RobotModule {
    protected Opponent target = null;
    protected Tracking tracking;
    private int toFire;
    protected BulletTracking newBullet;

    public Gun(AdvancedRobot robot, Tracking tracking) {
        super(robot);
        this.tracking = tracking;
        this.toFire = 0;
        this.newBullet = null;
    }

    public Opponent getTarget() {
        return this.target;
    }

    @Override
    public void turn() {
        if (this.target != null && this.target.getLastEnergy() == 0.0 && this.robot.getGunHeat() == 0.0) {
            Position self = new Position((Robot)this.robot);
            self.modify(1L, this.robot.getVelocity(), this.robot.getHeadingRadians());
            this.newBullet = new BulletTracking(0.1, self, this.target, this.robot.getTime());
            this.newBullet.setFiringAngle(self.getDirectionTo(this.target.getLastPosition()));
        }
        if (this.newBullet != null) {
            double dir = this.robot.getGunHeadingRadians();
            dir = Utils.normalRelativeAngle((double)(this.newBullet.getFiringAngle() - dir));
            this.robot.setTurnGunRightRadians(dir);
            if (this.robot.getGunHeat() > 0.0) {
                Log.log(1, "Trying to fire from heated gun");
                this.newBullet = null;
            } else if (this.toFire == 1) {
                if (this.robot.getGunHeadingRadians() >= this.newBullet.getFiringAngle() - 1.0E-6 && this.robot.getGunHeadingRadians() <= this.newBullet.getFiringAngle() + 1.0E-6) {
                    Bullet b = this.robot.setFireBullet(this.newBullet.getEnergy());
                    if (b != null) {
                        this.newBullet.setValues(b, this.robot.getTime());
                        this.tracking.bulletFired(this.newBullet, this.target);
                    }
                } else {
                    Log.log(2, "Missed fire, gun not turned");
                }
                this.toFire = 0;
                this.newBullet = null;
            } else {
                this.toFire = 1;
            }
        } else if (this.target != null) {
            Position p = new Position((Robot)this.robot);
            double dir = this.robot.getGunHeadingRadians();
            dir = Utils.normalRelativeAngle((double)(p.getDirectionTo(this.target.getLastPosition()) - dir));
            if (dir > 1.0471975511965976) {
                this.robot.setTurnGunRightRadians(Rules.GUN_TURN_RATE_RADIANS);
            } else if (dir < -1.0471975511965976) {
                this.robot.setTurnGunRightRadians(-Rules.GUN_TURN_RATE_RADIANS);
            }
        }
    }

    public void robotDeath(RobotDeathEvent e) {
        Opponent o = this.tracking.getByName(e.getName());
        if (o == this.target) {
            this.target = null;
        }
    }

    public void hitRobot(Opponent o) {
        this.tracking.setOpponentOfInterest(this.target);
        this.target = o;
    }
}

