/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.decomposition;

import org.la4j.Matrices;
import org.la4j.Matrix;
import org.la4j.decomposition.MatrixDecompositor;
import org.la4j.decomposition.RawQRDecompositor;

public class QRDecompositor
extends RawQRDecompositor
implements MatrixDecompositor {
    public QRDecompositor(Matrix matrix) {
        super(matrix);
    }

    @Override
    public Matrix[] decompose() {
        int j;
        Matrix[] qrr = super.decompose();
        Matrix qr = qrr[0];
        Matrix r = qrr[1];
        Matrix q = qr.blank();
        for (int k = q.columns() - 1; k >= 0; --k) {
            q.set(k, k, 1.0);
            for (j = k; j < q.columns(); ++j) {
                int i;
                if (!(Math.abs(qr.get(k, k)) > Matrices.EPS)) continue;
                double acc = 0.0;
                for (i = k; i < q.rows(); ++i) {
                    acc += qr.get(i, k) * q.get(i, j);
                }
                acc = -acc / qr.get(k, k);
                for (i = k; i < q.rows(); ++i) {
                    q.updateAt(i, j, Matrices.asPlusFunction(acc * qr.get(i, k)));
                }
            }
        }
        for (int i = 0; i < r.rows(); ++i) {
            for (j = i + 1; j < r.columns(); ++j) {
                r.set(i, j, qr.get(i, j));
            }
        }
        return new Matrix[]{q, r};
    }
}

