/*
 * Decompiled with CFR 0.152.
 */
package nosteel.Modules.Move;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ListIterator;
import nosteel.Basics.Draw;
import nosteel.Basics.Vector;
import nosteel.Modules.Aiming;
import nosteel.Modules.Data.EnemyData;
import nosteel.Modules.Data.ScanData;
import nosteel.Modules.DataList;
import nosteel.Modules.Move.MoveAlgo;
import robocode.util.Utils;

public class AntiG
extends MoveAlgo {
    static int NUMBER_OF_ENEMIES = 100;
    static Vector[] enemyPoints = new Vector[NUMBER_OF_ENEMIES];
    int countAdmin = 0;
    int countEnemy = 0;
    private double angle = 0.0;
    private Vector force = new Vector();

    public AntiG(DataList s, Aiming t) {
        super(s, t);
    }

    @Override
    public void intitalize() {
        this.constructDirectWalls();
    }

    @Override
    public void process(Vector myPos_, double myHeading_) {
        super.process(myPos_, myHeading_);
        this.updateDirectWalls();
        this.updateEnemies();
        this.calcForce(this.myPos);
        this.calcAngel(this.myHeading);
    }

    public void constructDirectWalls() {
        AntiG.enemyPoints[this.countAdmin++] = new Vector();
        AntiG.enemyPoints[this.countAdmin++] = new Vector();
        AntiG.enemyPoints[this.countAdmin++] = new Vector();
        AntiG.enemyPoints[this.countAdmin++] = new Vector();
    }

    public void updateDirectWalls() {
        AntiG.enemyPoints[0].x = this.myPos.x;
        AntiG.enemyPoints[0].y = 0.0;
        AntiG.enemyPoints[1].x = 0.0;
        AntiG.enemyPoints[1].y = this.myPos.y;
        AntiG.enemyPoints[2].x = this.myPos.x;
        AntiG.enemyPoints[2].y = this.battleSize.y;
        AntiG.enemyPoints[3].x = this.battleSize.x;
        AntiG.enemyPoints[3].y = this.myPos.y;
    }

    private void updateEnemies() {
        this.countEnemy = 0;
        ListIterator<EnemyData> it = null;
        it = this.scans.getEnemyListIterator(DataList.FRONT_OF_LIST);
        while (it.hasNext()) {
            EnemyData eId = it.next();
            ScanData scan = eId.getLastScan();
            if (scan == null) continue;
            AntiG.enemyPoints[this.countAdmin + this.countEnemy++] = new Vector(scan.vHisPos.x, scan.vHisPos.y);
        }
    }

    private void calcForce(Vector myPos) {
        this.force.clear();
        for (int i = 0; i < NUMBER_OF_ENEMIES && enemyPoints[i] != null; ++i) {
            Vector t = myPos.substract(enemyPoints[i]);
            double absBearing = t.getDirection();
            double distance = t.getLength();
            this.force.x -= Math.sin(absBearing) / (distance * distance);
            this.force.y -= Math.cos(absBearing) / (distance * distance);
        }
        this.angle = Utils.normalAbsoluteAngle((double)(this.force.getDirection() + Math.PI));
    }

    private void calcAngel(double myHeading) {
        if (!this.force.isNull()) {
            if (Math.abs(this.angle - myHeading) < 1.5707963267948966) {
                this.finalAngle = Utils.normalRelativeAngle((double)(this.angle - myHeading));
                this.finalDist = Double.POSITIVE_INFINITY;
            } else {
                this.finalAngle = Utils.normalRelativeAngle((double)(this.angle + Math.PI - myHeading));
                this.finalDist = Double.NEGATIVE_INFINITY;
            }
        }
    }

    @Override
    public void draw(Graphics2D g) {
        g.setColor(Color.BLUE);
        for (int i = 0; i < NUMBER_OF_ENEMIES && enemyPoints[i] != null; ++i) {
            Vector t = this.myPos.substract(enemyPoints[i]);
            Draw.drawPoint(g, enemyPoints[i], 10);
        }
        Draw.drawVectorAtPosition(g, this.myPos, this.force);
    }
}

