/*
 * Decompiled with CFR 0.152.
 */
package ags.muse.radar;

import ags.muse.base.actors.RadarActor;
import ags.muse.recon.Enemy;
import ags.muse.recon.EnemyList;
import ags.muse.recon.SelfStatus;
import ags.util.points.RelativePoint;
import robocode.util.Utils;

public class BasicRadar {
    private final SelfStatus status;
    private final EnemyList enemyList;
    private static final double TURN_PAST = 0.15707963267948966;

    public BasicRadar(SelfStatus status, EnemyList enemyList) {
        this.enemyList = enemyList;
        this.status = status;
    }

    public void run(RadarActor actor) {
        Enemy target = null;
        for (Enemy t : this.enemyList.getBots()) {
            if (t.getScanAge() != 0) continue;
            target = t;
            break;
        }
        if (target == null) {
            actor.setTurnRadar(Double.POSITIVE_INFINITY);
        } else {
            RelativePoint rel = RelativePoint.fromPP(this.status.getLocation(), target.getLocation());
            double radarturn = Utils.normalRelativeAngle((double)(rel.direction - this.status.status.getRadarHeadingRadians()));
            radarturn = radarturn >= 0.0 ? (radarturn += 0.15707963267948966) : (radarturn -= 0.15707963267948966);
            actor.setTurnRadar(radarturn);
        }
    }
}

