/*
 * Decompiled with CFR 0.152.
 */
package rdt.Utils;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import rdt.AgentSmith.AgentSmith;
import rdt.RobotData.RobotDataSnapshot;
import rdt.Utils.CircleCircleIntersectionResult;
import rdt.Utils.MathUtils;
import rdt.Utils.RuleUtils;
import robocode.Rules;
import robocode.util.Utils;

public class MaximumEscapeAngle {
    private ArrayList<CircleCircleIntersectionResult> _intersectionResultsForward = new ArrayList();
    private ArrayList<CircleCircleIntersectionResult> _intersectionResultsBack = new ArrayList();
    private int _maxTicksToCheck = 75;
    private double _battlefieldWidth;
    private double _battlefieldHeight;
    private double _forwardMEA;
    private double _rearMEA;
    private double _absoluteHeadOnAngle;
    private double _sourceX;
    private double _sourceY;

    public MaximumEscapeAngle(double sourceX, double sourceY, RobotDataSnapshot target, double firepower) {
        int index = 0;
        while (index < this._maxTicksToCheck) {
            this._intersectionResultsForward.add(new CircleCircleIntersectionResult());
            this._intersectionResultsBack.add(new CircleCircleIntersectionResult());
            ++index;
        }
        this._battlefieldWidth = AgentSmith.Instance().getBattleFieldWidth();
        this._battlefieldHeight = AgentSmith.Instance().getBattleFieldHeight();
        this._absoluteHeadOnAngle = target.AbsoluteAngleFromTarget;
        this._sourceX = sourceX;
        this._sourceY = sourceY;
        this.Recalculate(this._sourceX, this._sourceY, target, firepower);
    }

    public double GetMaxEscapeAngleForward() {
        return this._forwardMEA;
    }

    public double GetMinimumEscapeAngleRear() {
        return this._rearMEA;
    }

    private void Recalculate(double sourceX, double sourceY, RobotDataSnapshot target, double firepower) {
        double targetAbsVelocity = Math.abs(target.VelocityAlongHeading);
        this.RecalculateIntersections(sourceX, sourceY, target.LocationX, target.LocationY, targetAbsVelocity, firepower, this._intersectionResultsForward);
        this.RecalculateIntersections(sourceX, sourceY, target.LocationX, target.LocationY, -targetAbsVelocity, firepower, this._intersectionResultsBack);
        this.CalculateForwardMEA(sourceX, sourceY, target);
        this.CalculateRearMEA(sourceX, sourceY, target);
    }

    private void CalculateForwardMEA(double sourceX, double sourceY, RobotDataSnapshot target) {
        double targetDistance = target.DistanceToTarget;
        double angleForward = this._absoluteHeadOnAngle + target.RotationDirectionToTarget;
        double pointOnSideOfLineX = sourceX + Math.sin(angleForward) * targetDistance;
        double pointOnSideOfLineY = sourceY + Math.cos(angleForward) * targetDistance;
        this._forwardMEA = this.GetMaxAngleOnSideOfLine(sourceX, sourceY, target.LocationX, target.LocationY, this._intersectionResultsForward, pointOnSideOfLineX, pointOnSideOfLineY);
        this._forwardMEA = Utils.normalAbsoluteAngle((double)this._forwardMEA);
    }

    private void CalculateRearMEA(double sourceX, double sourceY, RobotDataSnapshot target) {
        double targetDistance = target.DistanceToTarget;
        double angleRear = this._absoluteHeadOnAngle - target.RotationDirectionToTarget;
        double pointOnSideOfLineX = sourceX + Math.sin(angleRear) * targetDistance;
        double pointOnSideOfLineY = sourceY + Math.cos(angleRear) * targetDistance;
        this._rearMEA = this.GetMaxAngleOnSideOfLine(sourceX, sourceY, target.LocationX, target.LocationY, this._intersectionResultsBack, pointOnSideOfLineX, pointOnSideOfLineY);
        this._rearMEA = Utils.normalAbsoluteAngle((double)this._rearMEA);
    }

    private double GetMaxAngleOnSideOfLine(double sourceX, double sourceY, double targetX, double targetY, ArrayList<CircleCircleIntersectionResult> intersectionResults, double sideOfLineX, double sideOfLineY) {
        double middleAngle;
        double maxAngle = middleAngle = this._absoluteHeadOnAngle;
        double maxDiff = -1.0;
        double sideOfLineD = MathUtils.PointOnSideOfLine(sourceX, sourceY, targetX, targetY, sideOfLineX, sideOfLineY);
        double correctSideOfLineSignum = Math.signum(sideOfLineD);
        boolean r1CorrectSideOfLine = true;
        int index = 0;
        while (index < intersectionResults.size()) {
            CircleCircleIntersectionResult result = intersectionResults.get(index);
            if (result.Intersection) {
                double r1SideOfLine = MathUtils.PointOnSideOfLine(sourceX, sourceY, targetX, targetY, result.X1, result.Y1);
                if (Math.signum(r1SideOfLine) == correctSideOfLineSignum) break;
                r1CorrectSideOfLine = false;
                break;
            }
            ++index;
        }
        double edgePadding = AgentSmith.Instance().GetBotSizeMaxHalf();
        int index2 = 0;
        while (index2 < intersectionResults.size()) {
            CircleCircleIntersectionResult result = intersectionResults.get(index2);
            if (result.Intersection) {
                double angleToCheck;
                double angleDiff;
                double x = result.X1;
                double y = result.Y1;
                if (r1CorrectSideOfLine) {
                    boolean r1Outside;
                    if (maxDiff > 0.0 && (r1Outside = RuleUtils.IsOutsideBattlefield(result.X1, result.Y1, edgePadding, this._battlefieldWidth, this._battlefieldHeight))) {
                        break;
                    }
                } else {
                    boolean r2Outside;
                    if (maxDiff > 0.0 && (r2Outside = RuleUtils.IsOutsideBattlefield(result.X2, result.Y2, edgePadding, this._battlefieldWidth, this._battlefieldHeight))) break;
                    x = result.X2;
                    y = result.Y2;
                }
                if ((angleDiff = Math.abs(Utils.normalRelativeAngle((double)((angleToCheck = MathUtils.GetAngle(sourceX, sourceY, x, y)) - middleAngle)))) > maxDiff) {
                    maxDiff = angleDiff;
                    maxAngle = angleToCheck;
                }
            }
            ++index2;
        }
        return maxAngle;
    }

    private void RecalculateIntersections(double sourceX, double sourceY, double targetX, double targetY, double initialVelocity, double firepower, ArrayList<CircleCircleIntersectionResult> results) {
        double bulletVelocity = Rules.getBulletSpeed((double)firepower);
        double targetVelocity = initialVelocity;
        double currentBulletDistance = 0.0;
        double currentTargetDistance = 0.0;
        int currentTick = 0;
        while (currentTick < this._maxTicksToCheck) {
            CircleCircleIntersectionResult result = results.get(currentTick);
            if (targetVelocity < 8.0) {
                targetVelocity = targetVelocity < 0.0 ? (targetVelocity += 2.0) : Math.min(8.0, targetVelocity + 1.0);
            }
            currentBulletDistance += bulletVelocity;
            if (!((currentTargetDistance += targetVelocity) < 0.0)) {
                MathUtils.CircleCircleIntersection(sourceX, sourceY, currentBulletDistance, targetX, targetY, currentTargetDistance, result);
            }
            ++currentTick;
        }
    }

    public double GetAbsAngleFromGuessFactor(double guessFactor) {
        double angle = this._absoluteHeadOnAngle;
        if (guessFactor > 0.0) {
            double range = Utils.normalRelativeAngle((double)(this._forwardMEA - this._absoluteHeadOnAngle));
            angle = this._absoluteHeadOnAngle + range * guessFactor;
        } else if (guessFactor < 0.0) {
            double range = Utils.normalRelativeAngle((double)(this._absoluteHeadOnAngle - this._rearMEA));
            angle = this._absoluteHeadOnAngle + range * guessFactor;
        }
        angle = Utils.normalAbsoluteAngle((double)angle);
        return angle;
    }

    public double GetGuessFactorFromAbsoluteAngle(double absoluteAngle, double targetRotationDirection) {
        double range;
        double relativeAngle = Utils.normalRelativeAngle((double)(absoluteAngle - this._absoluteHeadOnAngle)) * targetRotationDirection;
        double gf = 0.0;
        if (relativeAngle > 0.0) {
            double range2 = Math.abs(Utils.normalRelativeAngle((double)(this._forwardMEA - this._absoluteHeadOnAngle)));
            if (range2 > 0.0) {
                gf = relativeAngle / range2;
            }
        } else if (relativeAngle < 0.0 && (range = Math.abs(Utils.normalRelativeAngle((double)(this._absoluteHeadOnAngle - this._rearMEA)))) > 0.0) {
            gf = relativeAngle / range;
        }
        return gf;
    }

    public double GetRelativeAngleFromGuessFactor(double gf) {
        double absAngle = this.GetAbsAngleFromGuessFactor(gf);
        double relativeAngle = absAngle - this._absoluteHeadOnAngle;
        return Utils.normalRelativeAngle((double)relativeAngle);
    }

    public double GetHeadOnAngle() {
        return this._absoluteHeadOnAngle;
    }

    public void DebugDraw(Graphics2D gfx, double sourceX, double sourceY) {
        int squareSize = 10;
        int squareSizeHalf = squareSize / 2;
        int index = 0;
        while (index < this._maxTicksToCheck) {
            CircleCircleIntersectionResult resultForward = this._intersectionResultsForward.get(index);
            if (resultForward.Intersection) {
                gfx.setColor(Color.white);
                gfx.drawRect((int)resultForward.X1 - squareSizeHalf, (int)resultForward.Y1 - squareSizeHalf, squareSize, squareSize);
                gfx.drawRect((int)resultForward.X2 - squareSizeHalf, (int)resultForward.Y2 - squareSizeHalf, squareSize, squareSize);
            }
            CircleCircleIntersectionResult resultBack = this._intersectionResultsBack.get(index);
            if (resultForward.Intersection) {
                gfx.setColor(Color.gray);
                gfx.drawRect((int)resultBack.X1 - squareSizeHalf, (int)resultBack.Y1 - squareSizeHalf, squareSize, squareSize);
                gfx.drawRect((int)resultBack.X2 - squareSizeHalf, (int)resultBack.Y2 - squareSizeHalf, squareSize, squareSize);
            }
            ++index;
        }
        double forwardMEAX = sourceX + Math.sin(this._forwardMEA) * 500.0;
        double forwardMEAY = sourceY + Math.cos(this._forwardMEA) * 500.0;
        double rearMEAX = sourceX + Math.sin(this._rearMEA) * 500.0;
        double rearMEAY = sourceY + Math.cos(this._rearMEA) * 500.0;
        gfx.drawLine((int)sourceX, (int)sourceY, (int)forwardMEAX, (int)forwardMEAY);
        gfx.drawLine((int)sourceX, (int)sourceY, (int)rearMEAX, (int)rearMEAY);
    }
}

