/*
 * Decompiled with CFR 0.152.
 */
package tcf;

import robocode.Bullet;
import robocode.util.Utils;
import tcf.Arena;
import tcf.Bot;
import tcf.GuessFactor;
import tcf.HistoryBot;
import tcf.SimBot;

class PredState {
    final Arena m_arena;
    final SimBot m_gun;
    final double m_shotSpeed;
    final HistoryBot m_target;
    final Bullet m_bullet;
    final double m_angleAhead;
    final double m_angleBehind;
    final double m_hotBearing;

    PredState(Arena arena, Bot bot, double d, HistoryBot historyBot, Bullet bullet) {
        this.m_arena = arena;
        this.m_gun = new SimBot(bot);
        this.m_shotSpeed = d;
        this.m_target = new HistoryBot(historyBot);
        this.m_bullet = bullet;
        this.m_angleAhead = GuessFactor.calcAngle(true, bot, d, historyBot);
        this.m_angleBehind = GuessFactor.calcAngle(false, bot, d, historyBot);
        this.m_hotBearing = Math.atan2(this.m_target.x() - this.m_gun.x(), this.m_target.y() - this.m_gun.y());
    }

    PredState(Arena arena, Bot bot, double d, HistoryBot historyBot) {
        this(arena, bot, d, historyBot, null);
    }

    public double calcGfFromPos(double d, double d2) {
        double d3 = Math.atan2(d - this.m_gun.x(), d2 - this.m_gun.y());
        double d4 = Utils.normalRelativeAngle((double)(d3 - this.m_hotBearing));
        double d5 = (d4 - this.m_angleBehind) / (this.m_angleAhead - this.m_angleBehind);
        return d5;
    }
}

