/*
 * Decompiled with CFR 0.152.
 */
package xander.core.paint;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collections;
import xander.core.Resources;
import xander.core.RobotProxy;
import xander.core.event.Painter;
import xander.core.log.Logger;
import xander.core.track.GunStats;

public class GunHitRatioPainter
implements Painter {
    private RobotProxy robotProxy = Resources.getRobotProxy();
    private GunStats gunStats;

    public GunHitRatioPainter(GunStats gunStats) {
        this.gunStats = gunStats;
    }

    @Override
    public void onPaint(Graphics2D g) {
        float y = (float)this.robotProxy.getBattleFieldSize().getCenterY();
        float x = (float)this.robotProxy.getBattleFieldSize().getMaxX() - 250.0f;
        g.setColor(Color.WHITE);
        ArrayList<String> gunNames = new ArrayList<String>();
        gunNames.addAll(this.gunStats.getGunNames());
        Collections.sort(gunNames);
        for (String gunName : gunNames) {
            String hr = String.valueOf(Logger.format(100.0 * this.gunStats.getHitRatio(gunName), 1, 1)) + "%";
            String vhr = String.valueOf(Logger.format(100.0 * this.gunStats.getVirtualHitRatio(gunName), 1, 1)) + "%";
            String rvhr = String.valueOf(Logger.format(100.0 * this.gunStats.getRollingVirtualHitRatio(gunName), 1, 1)) + "%";
            g.drawString("A:" + hr + " RV: " + rvhr + " V:" + vhr + " " + gunName, x, y);
            y -= 20.0f;
        }
    }
}

