/*
 * Decompiled with CFR 0.152.
 */
package TNT;

import TNT.EnemyFiredListener;
import TNT.Pattern;
import TNT.PatternAnalyzer;
import TNT.Recon;
import TNT.TNT;
import java.util.ArrayList;

class ReconCollection {
    private static final int MAX_UNDETECTED_TARGET_TURNS = 20;
    protected static final String TNT_BOT = "TNT";
    private static EnemyFiredListener m_listener = null;
    private int MAX_STACK_SIZE = 50;
    private Recon[] allInformation = new Recon[this.MAX_STACK_SIZE];
    private int next = 0;
    private int size = 0;
    private TNT m_owner = null;
    private Pattern m_movePattern = PatternAnalyzer.DEFAULT;

    public void setPattern(Pattern in_newPattern) {
        this.m_movePattern = in_newPattern != null ? in_newPattern : PatternAnalyzer.DEFAULT;
    }

    public Pattern getPattern() {
        return this.m_movePattern;
    }

    public static void setEnemyFireListener(EnemyFiredListener in_listener) {
        m_listener = in_listener;
    }

    protected void fireEnemyFiredEvent() {
        if (m_listener != null) {
            m_listener.enemyFired(this.get(0));
        }
    }

    public void addRecon(Recon in_new) {
        Recon lastRecon = this.get(0);
        if (lastRecon != null && lastRecon.getLife() - in_new.getLife() <= 3.0 && lastRecon.getLife() - in_new.getLife() >= 0.1) {
            this.fireEnemyFiredEvent();
        }
        this.size = this.size == this.MAX_STACK_SIZE ? this.size : this.size + 1;
        this.allInformation[this.next] = in_new;
        this.next = (this.next + 1) % this.MAX_STACK_SIZE;
    }

    public Recon get(int in_index) {
        int index = this.next - in_index - 1;
        if (index < 0) {
            index += this.MAX_STACK_SIZE;
        }
        return this.allInformation[index];
    }

    protected Recon[] toArray() {
        Recon[] out_array = new Recon[this.size];
        int iCounter = 0;
        while (iCounter < this.size) {
            out_array[iCounter] = this.get(iCounter);
            ++iCounter;
        }
        return out_array;
    }

    public void clear() {
        this.allInformation = new Recon[this.MAX_STACK_SIZE];
        this.next = 0;
        this.size = 0;
    }

    public int getInformationCount() {
        return this.size;
    }

    public boolean notMovingForTerms(int in_numberOfTerms) {
        int iCounter = 0;
        while (iCounter < in_numberOfTerms) {
            if (this.get(iCounter) == null || this.get(iCounter).getVelocity() != 0.0) {
                return false;
            }
            ++iCounter;
        }
        return true;
    }

    public boolean isCurrent() {
        if (this.get(0) != null) {
            return this.m_owner.getTime() - this.get(0).getTime() <= 20L && this.m_owner.getRoundNum() == this.get(0).getRoundNum();
        }
        return false;
    }

    public boolean isTNT() {
        return this.get(0) != null && this.get(0).getName().startsWith(TNT_BOT);
    }

    public Recon[] getLatestStrand() {
        if (this.isCurrent()) {
            ArrayList<Recon> out_list = new ArrayList<Recon>(this.MAX_STACK_SIZE);
            int currentIndex = -1;
            Recon[] out_recon = null;
            do {
                out_list.add(this.get(++currentIndex));
            } while (currentIndex + 1 < this.MAX_STACK_SIZE && this.get(currentIndex + 1) != null && this.get(currentIndex).getTime() - this.get(currentIndex + 1).getTime() <= 20L && this.m_owner.getRoundNum() == this.get(currentIndex + 1).getRoundNum());
            out_recon = new Recon[out_list.size()];
            int iCounter = 0;
            while (iCounter < out_list.size()) {
                out_recon[iCounter] = (Recon)out_list.get(iCounter);
                ++iCounter;
            }
            return out_recon;
        }
        return null;
    }

    public ReconCollection(TNT in_owner) {
        this.m_owner = in_owner;
    }
}

