/*
 * Decompiled with CFR 0.152.
 */
package cbot.agile;

import cbot.agile.CU;

public class Point {
    public double x;
    public double y;

    public double getAngle(Point newPoint) {
        double diffX = newPoint.getX() - this.x;
        double diffY = newPoint.getY() - this.y;
        double angle = Math.atan(diffX / diffY);
        return diffY < 0.0 ? angle + Math.PI : angle;
    }

    public double getDistance(Point newPoint) {
        double diffX = newPoint.getX() - this.x;
        double diffY = newPoint.getY() - this.y;
        double distance = Math.sqrt(diffX * diffX + diffY * diffY);
        return distance;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public static Point getNewPoint(Point reference, double distance, double angle) {
        double x = reference.getX() + distance * Math.sin(angle);
        double y = reference.getY() + distance * Math.cos(angle);
        return Point.putPointInValidArea(new Point(x, y));
    }

    public void move(double distance, double angle) {
        this.x += distance * Math.sin(angle);
        this.y += distance * Math.cos(angle);
    }

    public static Point putPointInValidArea(Point p) {
        int extraSpace = 40;
        double REAL_GAME_WIDTH = CU.GAMEWIDTH - 20.0 - 40.0;
        double REAL_GAME_HEIGHT = CU.GAMEHEIGHT - 20.0 - 40.0;
        if (p.x > REAL_GAME_WIDTH) {
            p.x = REAL_GAME_WIDTH;
        } else if (p.x < 60.0) {
            p.x = 60.0;
        }
        if (p.y > REAL_GAME_HEIGHT) {
            p.y = REAL_GAME_HEIGHT;
        } else if (p.y < 60.0) {
            p.y = 60.0;
        }
        return p;
    }

    public boolean inArea(Point p1, Point p2) {
        if (this.x < p1.x || this.x > p2.x) {
            return false;
        }
        return !(this.y > p1.y) && !(this.y < p2.y);
    }

    public boolean inArea(Point p1, double distance) {
        if (this.x < p1.x - distance || this.x > p1.x + distance) {
            return false;
        }
        return !(this.y > p1.y + distance) && !(this.y < p1.y - distance);
    }

    public boolean equals(Object o) {
        Point p = (Point)o;
        boolean bl = false;
        if (this.x == p.getX() && this.y == p.getY()) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        return "[" + CU.formatNumber(this.x) + " | " + CU.formatNumber(this.y) + ']';
    }

    public Point(double x, double y) {
        this.x = x;
        this.y = y;
    }
}

