/*
 * Decompiled with CFR 0.152.
 */
package cbot.agile.driver;

import cbot.agile.CU;
import cbot.agile.Nibbler;
import cbot.agile.Point;
import cbot.agile.Pray;
import cbot.agile.driver.AbstractDriver;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RandomPointDriver
extends AbstractDriver {
    private int stopTics;
    private boolean didStop;
    private int driveDirection;
    private int sameDirection;
    boolean prayIsFiering;
    double[] collisionTimes;
    double[] maxDrivingDistances;
    double[] accumelatedDrivingDistances;
    int numOfBullets;
    double accumelatedDrivingDistance;
    int changeDistance;
    private final Point TOP_LEFT_VALID_CORNER;
    private final Point BOTTOM_RIGHT_VALID_CORNER;

    public void update(Nibbler robot) {
        super.update(robot);
    }

    public void drive(Pray pray) {
        super.drive(pray);
        if (Math.abs(this.robot.getDistanceRemaining()) < 1.0) {
            this.stopTics = this.getStopTicks(pray);
            if (this.stopTics > 0) {
                this.handleStopTick();
            } else {
                this.robot.setMaxTurnRate(10.0);
                this.driveToPoint(this.getGoToPoint(pray));
            }
        }
    }

    public void handleBeingFiredAt(Pray pray, double firePower, double fireTime) {
        this.prayIsFiering = true;
        double bulletTravelTime = pray.getDistance() / CU.getBulletVelocity(pray.getLastFirePower());
        double newCollisionTime = (double)this.robot.getTime() + bulletTravelTime;
        double[] tmp = new double[5];
        int i = 0;
        while (i < this.collisionTimes.length) {
            if (newCollisionTime < this.collisionTimes[i]) {
                int count = 0;
                int j = 0;
                while (j < this.collisionTimes.length) {
                    if (i == j) break;
                    tmp[count++] = this.collisionTimes[j];
                    ++j;
                }
                this.collisionTimes = tmp;
            }
            ++i;
        }
        this.collisionTimes[this.numOfBullets] = newCollisionTime;
        this.maxDrivingDistances[this.numOfBullets] = CU.getBulletVelocity(firePower) * bulletTravelTime;
    }

    public void handleBeeingHit() {
        this.robot.setStop(true);
    }

    private final Point getGoToPoint(Pray pray) {
        Point newGoToPoint = new Point(10000.0, 10000.0);
        int count = 0;
        while (!newGoToPoint.inArea(this.TOP_LEFT_VALID_CORNER, this.BOTTOM_RIGHT_VALID_CORNER) && count++ < 10) {
            double distance = this.getDrivingDistance(pray);
            double angle = this.getDrivingAngle(distance);
            newGoToPoint = Point.getNewPoint(this.robot.currentCordinate, distance, Math.toRadians(angle));
        }
        if (count == 10) {
            Point.putPointInValidArea(newGoToPoint);
        }
        return newGoToPoint;
    }

    private final double getDrivingAngle(double distance) {
        double extraAngle = this.changeDistance == 0 ? 40.0 : (distance > 0.0 ? 60.0 : 20.0);
        return Math.random() * 80.0 - extraAngle + this.getParallelAngle();
    }

    private final void adjustChangeDistance() {
        double prayEnergy = this.currentPray.getEnergy();
        double robotEnergy = this.robot.getEnergy();
        this.changeDistance = prayEnergy < (double)3 && robotEnergy > prayEnergy * (double)5 ? -1 : (robotEnergy < (double)3 && prayEnergy > robotEnergy * (double)2 ? 1 : 0);
    }

    private final double _getDrivingDistance(Pray pray) {
        double maxDriveDistance = this.getMaxDrivingDistance(pray);
        int oldDirection = this.driveDirection;
        maxDriveDistance *= Math.random() * 0.75;
        maxDriveDistance += Math.random() > 0.8 ? 0.4 : 0.0;
        int n = 1;
        if (!(Math.random() < 0.65)) {
            n = CU.randSign();
        }
        this.driveDirection *= n;
        int n2 = 0;
        if (oldDirection == this.driveDirection) {
            n2 = this.sameDirection = this.sameDirection + 1;
        }
        if (this.sameDirection >= 3) {
            this.driveDirection *= Math.random() < 0.8 ? -1 : 1;
        }
        return Math.max(30.0, maxDriveDistance) * (double)this.driveDirection;
    }

    private final double getDrivingDistance(Pray pray) {
        double distanceToDrive;
        double maxDistance;
        double maxDriveDistance = maxDistance = this.getMaxDrivingDistance(pray);
        if (pray.getDistance() < 100.0) {
            this.driveDirection *= Math.random() < 0.9 ? -1 : CU.randSign();
            distanceToDrive = Math.max(30.0, maxDriveDistance *= Math.random() * 0.6) * (double)this.driveDirection;
            double accumelated = this.accumelatedDrivingDistances[0] + distanceToDrive;
            if (accumelated < maxDistance && accumelated > maxDistance * 0.4) {
                distanceToDrive = accumelated * 0.5;
            }
        } else if (pray.getDistance() < 250.0) {
            maxDriveDistance *= Math.random() * 0.7 + 0.6;
            this.driveDirection *= Math.random() < 0.8 ? -1 : CU.randSign();
            distanceToDrive = (maxDriveDistance += Math.random() < 0.6 ? Math.random() * 0.4 : 0.0) * (double)this.driveDirection;
            double accumelated = this.accumelatedDrivingDistances[0] + distanceToDrive;
            if (accumelated < maxDistance && accumelated > maxDistance * 0.6) {
                distanceToDrive = accumelated * 0.6;
            }
        } else if (pray.getDistance() < 500.0) {
            maxDriveDistance *= Math.random() * 0.7 + 0.6;
            this.driveDirection *= Math.random() < 0.7 ? -1 : CU.randSign();
            distanceToDrive = (maxDriveDistance += Math.random() < 0.4 ? Math.random() * 0.6 : 0.0) * (double)this.driveDirection;
            double accumelated = this.accumelatedDrivingDistances[0] + distanceToDrive;
            if (accumelated < maxDistance * 0.8 && accumelated > maxDistance * 0.6) {
                distanceToDrive = accumelated * 0.55;
            } else if (accumelated < maxDistance && accumelated > maxDistance * 0.4) {
                distanceToDrive = accumelated * 0.8;
            }
        } else {
            maxDriveDistance *= Math.random() * 0.8 + 0.7;
            this.driveDirection *= Math.random() < 0.7 ? -1 : CU.randSign();
            distanceToDrive = (maxDriveDistance += Math.random() < 0.6 ? Math.random() * 0.6 : 0.0) * (double)this.driveDirection;
            double accumelated = this.accumelatedDrivingDistances[0] + distanceToDrive;
            if (accumelated < maxDistance && accumelated > maxDistance * 0.6) {
                distanceToDrive = accumelated * 0.5;
            }
        }
        double finishedDriveTime = (double)this.robot.getTime() + distanceToDrive / this.robot.getVelocity();
        double nextCollisionTime = this.collisionTimes[0];
        if (finishedDriveTime >= nextCollisionTime) {
            this.removeNextBulletHit();
        }
        this.addDrivingDistance(distanceToDrive);
        return distanceToDrive;
    }

    private final void removeNextBulletHit() {
        int i = 1;
        while (i < this.numOfBullets) {
            this.collisionTimes[i - 1] = this.collisionTimes[i];
            this.maxDrivingDistances[i - 1] = this.maxDrivingDistances[i];
            this.accumelatedDrivingDistances[i - 1] = this.accumelatedDrivingDistances[i];
            --this.numOfBullets;
            ++i;
        }
    }

    private final void addDrivingDistance(double distance) {
        int i = 0;
        while (i < this.numOfBullets) {
            int n = i++;
            this.accumelatedDrivingDistances[n] = this.accumelatedDrivingDistances[n] + distance;
        }
    }

    private final double getMaxDrivingDistance(Pray pray) {
        double speed = pray.getDistance() > 250.0 ? (Math.random() < 0.3 ? Math.random() * (double)3 + (double)4 : 8.0) : 8.0;
        this.robot.setMaxVelocity(speed);
        double MAX_DRIVING_FACTOR = 1.0;
        double lastBulletTravelTime = pray.getDistance() / CU.getBulletVelocity(pray.getLastFirePower());
        double maxDriveDistance = lastBulletTravelTime * speed * MAX_DRIVING_FACTOR;
        return maxDriveDistance;
    }

    private final void handleStopTick() {
        --this.stopTics;
        double angle = 20.0;
        this.steerRight(angle *= (double)(this.stopTics % 2 == 0 ? 1 : -1));
    }

    private final int getStopTicks(Pray pray) {
        if (this.stopTics != 0) {
            return this.stopTics;
        }
        int ticks = 0;
        if (pray.getDistance() > 200.0 && this.stopTics == 0 && Math.random() < 0.2 && !this.didStop) {
            double lastBulletTravelTime = pray.getDistance() / CU.getBulletVelocity(pray.getLastFirePower());
            ticks = (int)(lastBulletTravelTime / (double)3);
            this.didStop = true;
        } else {
            this.didStop = false;
        }
        return ticks;
    }

    private final void driveToPoint(Point goToPoint) {
        double distance = this.getDistance(goToPoint);
        double angle = CU.normalRelativeAngle(this.getAngle(goToPoint) - this.robot.getHeading());
        this.steerRight(angle);
        this.forward(distance);
    }

    protected double getAngle(Point newPoint) {
        double diffX = newPoint.getX() - this.robot.getX();
        double diffY = newPoint.getY() - this.robot.getY();
        double angle = Math.atan(diffX / diffY);
        angle = diffY < 0.0 ? angle + Math.PI : angle;
        return Math.toDegrees(angle);
    }

    protected double getDistance(Point newPoint) {
        double diffX = newPoint.getX() - this.robot.getX();
        double diffY = newPoint.getY() - this.robot.getY();
        double distance = Math.sqrt(diffX * diffX + diffY * diffY);
        return distance;
    }

    private final /* synthetic */ void this() {
        this.stopTics = 0;
        this.didStop = false;
        this.driveDirection = 1;
        this.sameDirection = 0;
        this.prayIsFiering = false;
        this.collisionTimes = new double[5];
        this.maxDrivingDistances = new double[5];
        this.accumelatedDrivingDistances = new double[5];
        this.numOfBullets = 0;
        this.changeDistance = 0;
        this.TOP_LEFT_VALID_CORNER = new Point(75.0, 525.0);
        this.BOTTOM_RIGHT_VALID_CORNER = new Point(725.0, 75.0);
    }

    public RandomPointDriver(Nibbler robot) {
        super(robot);
        this.this();
        this.robot = robot;
    }
}

