/*
 * Decompiled with CFR 0.152.
 */
package ebo;

import de._4geeks.robots.guns.GunManager;
import de._4geeks.robots.movement.manager.MovementManager;
import java.awt.Color;
import java.awt.Graphics2D;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class Tahoe
extends AdvancedRobot {
    public static final boolean isTC = false;
    public static final boolean isMC = false;
    int skippedTurns = 0;
    double target_abs_bearing;
    long target_scan_time;
    GunManager gun;
    MovementManager movement;

    public void run() {
        this.setBodyColor(Color.black);
        this.setGunColor(Color.orange);
        this.setRadarColor(Color.orange);
        this.setScanColor(Color.orange);
        this.gun = new GunManager(this, false);
        this.movement = new MovementManager(this);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.turnRadarRightRadians(Math.PI * 2);
        while (true) {
            this.doMovement();
            this.doScanner();
            this.doGun();
            this.execute();
        }
    }

    private void gameOver() {
        if (this.getRoundNum() == this.getNumRounds() - 1) {
            if (this.gun != null) {
                this.gun.battleOver();
            }
        } else if (this.gun != null) {
            this.gun.roundOver();
        }
        System.out.println(String.format("Skipped Turns: %d", this.skippedTurns));
    }

    private void doMovement() {
    }

    private void doScanner() {
        if (this.getTime() - this.target_scan_time > 4L) {
            this.setTurnRadarLeftRadians(360.0);
        } else {
            this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(this.target_abs_bearing - this.getRadarHeadingRadians())) * 2.0);
        }
    }

    private void doGun() {
        if (this.gun != null) {
            this.gun.doGun();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.target_scan_time = this.getTime();
        this.target_abs_bearing = Utils.normalAbsoluteAngle((double)(this.getHeadingRadians() + e.getBearingRadians()));
        if (this.gun != null) {
            this.gun.onScannedRobot(e);
        }
        if (this.movement != null) {
            this.movement.onScannedRobot(e);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (this.movement != null) {
            this.movement.onHitByBullet(e);
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        if (this.gun != null) {
            this.gun.onBulletHit(e);
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        if (this.movement != null) {
            this.movement.onBulletHitBullet(e);
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (this.gun != null) {
            this.gun.onRobotDeath(e);
        }
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        System.out.println(String.format("Turn skipped: %d", this.getTime()));
        ++this.skippedTurns;
    }

    public void onDeath(DeathEvent e) {
        this.gameOver();
    }

    public void onWin(WinEvent e) {
        this.gameOver();
    }

    public void onPaint(Graphics2D g) {
        if (this.gun != null) {
            this.gun.onPaint(g);
        }
        if (this.movement != null) {
            this.movement.onPaint(g);
        }
    }
}

