/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CauseAndEffect<TCause, TEffect> {
    Map<TCause, Map<TEffect, Integer>> causeAndEffectMap = new HashMap<TCause, Map<TEffect, Integer>>();
    Map<TCause, Integer> totalCausesMap = new HashMap<TCause, Integer>();

    public void record(TCause cause, TEffect effect) {
        Map<TEffect, Integer> effects = this.causeAndEffectMap.get(cause);
        if (effects == null) {
            effects = new HashMap<TEffect, Integer>();
            effects.put(effect, 1);
            this.causeAndEffectMap.put(cause, effects);
            this.totalCausesMap.put(cause, 1);
        } else {
            Integer previousEffectCount = effects.get(effect);
            if (previousEffectCount == null) {
                effects.put(effect, 1);
            } else {
                effects.put(effect, previousEffectCount + 1);
            }
            this.totalCausesMap.put(cause, this.totalCausesMap.get(cause) + 1);
        }
    }

    public double getProbabilityOf(TCause cause, TEffect effect) {
        Integer effectCount;
        Map<TEffect, Integer> effects = this.causeAndEffectMap.get(cause);
        if (effects != null && effect != null && (effectCount = effects.get(effect)) != null) {
            return (double)effectCount.intValue() * 100.0 / (double)this.totalCausesMap.get(cause).intValue();
        }
        return 0.0;
    }

    public TEffect getMostLikelyEffectOf(TCause cause) {
        Map<TEffect, Integer> effects = this.causeAndEffectMap.get(cause);
        TEffect likelyEffect = null;
        if (effects != null) {
            int maxFrequency = 0;
            for (Map.Entry<TEffect, Integer> entry : effects.entrySet()) {
                if (entry.getValue() <= maxFrequency) continue;
                maxFrequency = entry.getValue();
                likelyEffect = entry.getKey();
            }
        }
        return likelyEffect;
    }

    public void purge(int maxCauses) {
        int needToRemove = this.totalCausesMap.size() - Math.max(0, maxCauses);
        if (needToRemove > 0) {
            ArrayList<CauseAndFreq> sortedCauses = new ArrayList<CauseAndFreq>();
            for (Map.Entry<TCause, Integer> entry : this.totalCausesMap.entrySet()) {
                sortedCauses.add(new CauseAndFreq(entry.getKey(), entry.getValue()));
            }
            Collections.sort(sortedCauses);
            while (needToRemove-- > 0) {
                ((CauseAndFreq)sortedCauses.get(needToRemove)).purge();
            }
        }
    }

    public int getLength() {
        return this.totalCausesMap.size();
    }

    private class CauseAndFreq
    implements Comparable<CauseAndFreq> {
        TCause cause;
        int frequency;

        public CauseAndFreq(TCause cause, int frequency) {
            this.cause = cause;
            this.frequency = frequency;
        }

        @Override
        public int compareTo(CauseAndFreq compareWith) {
            return this.frequency - compareWith.frequency;
        }

        public void purge() {
            CauseAndEffect.this.totalCausesMap.remove(this.cause);
            CauseAndEffect.this.causeAndEffectMap.remove(this.cause);
        }
    }
}

