/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.navigator;

import dmh.robocode.data.Location;
import dmh.robocode.enemy.EnemyRobot;
import dmh.robocode.navigator.NavigateToLocation;
import dmh.robocode.navigator.NavigatorCommand;
import dmh.robocode.navigator.target.EnemyTargetAlgorithm;
import dmh.robocode.simulate.SimulateableRobot;
import java.awt.Graphics2D;

public class NavigateToEnemy
implements NavigatorCommand {
    private Location targetLocation;
    private NavigateToLocation subNavigator;
    private EnemyRobot enemy;
    private EnemyTargetAlgorithm targetAlgorithm;

    public NavigateToEnemy(EnemyRobot enemy, SimulateableRobot myRobot, EnemyTargetAlgorithm targetAlgorithm) {
        this.enemy = enemy;
        this.targetAlgorithm = targetAlgorithm;
        this.targetLocation = targetAlgorithm.getRevisedTargetLocation();
        this.subNavigator = new NavigateToLocation(this.targetLocation, myRobot);
    }

    @Override
    public void setWiggleFactor(int wiggleFactor) {
        this.subNavigator.setWiggleFactor(wiggleFactor);
    }

    @Override
    public int getWiggleFactor() {
        return this.subNavigator.getWiggleFactor();
    }

    @Override
    public void setWiggleExpiry(long wiggleExpiry) {
        this.subNavigator.setWiggleExpiry(wiggleExpiry);
    }

    @Override
    public long getWiggleExpiry() {
        return this.subNavigator.getWiggleExpiry();
    }

    @Override
    public boolean isDone() {
        return !this.enemy.isAlive();
    }

    @Override
    public double getRightTurn() {
        return this.subNavigator.getRightTurn();
    }

    @Override
    public double getAhead() {
        return this.subNavigator.getAhead();
    }

    @Override
    public double getVelocity() {
        return this.subNavigator.getVelocity();
    }

    public EnemyRobot getEnemy() {
        return this.enemy;
    }

    @Override
    public void executed() {
        this.subNavigator.executed();
        if (this.enemy.getLatestRadarObservation() != null) {
            this.targetLocation = this.targetAlgorithm.getRevisedTargetLocation();
            this.subNavigator.setTarget(this.targetLocation);
        }
    }

    @Override
    public void reverseDirection() {
        this.subNavigator.reverseDirection();
    }

    @Override
    public void paint(Graphics2D g) {
        this.subNavigator.paint(g);
    }
}

