/*
 * Decompiled with CFR 0.152.
 */
package jab.radar;

import jab.module.Module;
import jab.module.Radar;
import robocode.util.Utils;

public class SpinningRadar
extends Radar {
    int direction = 0;

    public SpinningRadar(Module bot) {
        super(bot);
    }

    public void scan() {
        if (this.direction == 0) {
            this.direction = SpinningRadar.sign(this.calculateRelativeAngleToCenter(this.bot.getRadarHeadingRadians()));
        }
        this.bot.setTurnRadarRightRadians(Double.POSITIVE_INFINITY * (double)this.direction);
    }

    private static int sign(double v) {
        return v > 0.0 ? 1 : -1;
    }

    private double calculateRelativeAngleToCenter(double heading) {
        return Utils.normalRelativeAngle((double)(Math.atan2(this.bot.getBattleFieldWidth() / 2.0 - this.bot.getX(), this.bot.getBattleFieldHeight() / 2.0 - this.bot.getY()) - heading));
    }
}

