/*
 * Decompiled with CFR 0.152.
 */
package rc;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import rc.EnemyInfo;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;
import robocode.WinEvent;
import robocode.util.Utils;

public class RCBot
extends TeamRobot {
    static final double WALL_MARGIN = 17.0;
    static final double WALLAVOID = 35.0;
    static final long RADARTIMEOUT = 20L;
    private Point2D myPosition;
    private Point2D myLastPosition;
    private Point2D myGoalPosition;
    private Point2D centerPoint;
    private long currTime;
    private boolean radarScan;
    private long lastscan;
    private double oldHeading;
    private EnemyInfo currentTarget;
    private HashMap enemies;
    private double radarTurn;
    private static int HISTORY_SIZE = 10;
    private static int HISTORY_AVERAGE = 7;
    private static int historyPointer = 0;
    private static double[] historyTurn = new double[HISTORY_SIZE];
    private static double[] historyTurnAvg = new double[HISTORY_SIZE];
    private static double[] historyVelocity = new double[HISTORY_SIZE];
    private static double previousHeading;
    private double fieldWidth;
    private double fieldHeight;
    private RoundRectangle2D.Double playField;
    private Rectangle2D.Double fireField;
    static int[] finishes;

    public void run() {
        System.out.println("APLv5: Let's rock!");
        this.setColors(Color.black, Color.red, Color.black, Color.pink, Color.red);
        this.fieldWidth = this.getBattleFieldWidth();
        this.fieldHeight = this.getBattleFieldHeight();
        this.playField = new RoundRectangle2D.Double(35.0, 35.0, this.fieldWidth - 70.0, this.fieldHeight - 70.0, 50.0, 50.0);
        this.fireField = new Rectangle2D.Double(17.0, 17.0, this.fieldWidth - 34.0, this.fieldHeight - 34.0);
        this.centerPoint = new Point2D.Double(this.fieldWidth / 2.0, this.fieldHeight / 2.0);
        if (finishes == null) {
            finishes = new int[this.getOthers() + 1];
        }
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setTurnRadarRight(Double.POSITIVE_INFINITY);
        this.enemies = new HashMap();
        this.myPosition = new Point2D.Double();
        this.myLastPosition = new Point2D.Double();
        this.myGoalPosition = new Point2D.Double(this.getX(), this.getY());
        while (true) {
            this.currTime = this.getTime();
            this.doMeleeMovement();
            this.setTurnRadarRightRadians(this.radarTurn);
            this.radarTurn = this.radarTurn >= 0.0 ? 0.7853981633974483 : -0.7853981633974483;
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double angle;
        double head;
        double setRadar = this.getHeadingRadians() + e.getBearingRadians() + (this.radarTurn > 0.0 ? -0.19634954084936207 : 0.19634954084936207);
        if (setRadar > Math.PI * 2) {
            setRadar -= Math.PI * 2;
        } else if (setRadar < 0.0) {
            setRadar += Math.PI * 2;
        }
        this.radarTurn = this.radarTurn < 0.0 ? (setRadar < 0.0 ? setRadar + Math.PI * 2 : setRadar) : (setRadar > 0.0 ? setRadar - Math.PI * 2 : (setRadar -= this.getRadarHeadingRadians()));
        EnemyInfo enemy = (EnemyInfo)this.enemies.get(e.getName());
        if (enemy == null) {
            enemy = new EnemyInfo();
            this.enemies.put(e.getName(), enemy);
        }
        this.myPosition.setLocation(this.getX(), this.getY());
        double absBearing = this.getHeadingRadians() + e.getBearingRadians();
        double dist = e.getDistance();
        enemy.setLocation(this.myPosition.getX() + Math.sin(absBearing) * dist, this.myPosition.getY() + Math.cos(absBearing) * dist);
        enemy.energy = e.getEnergy();
        enemy.heading = e.getHeadingRadians();
        enemy.velocity = e.getVelocity();
        enemy.teammate = this.isTeammate(e.getName());
        if (enemy.teammate) {
            return;
        }
        double d = enemy.attrac = e.getEnergy() < 20.0 ? dist * 0.75 : dist;
        if (enemy != this.currentTarget && (this.currentTarget == null || enemy.attrac < this.currentTarget.attrac * 0.8 && this.currentTarget.attrac > 80.0 && dist < 1200.0)) {
            this.currentTarget = enemy;
        }
        double power = dist > 250.0 ? 1.9 : (dist > 700.0 ? 0.49 : (dist > 850.0 ? 0.1 : 3.0));
        power = Math.min(this.getEnergy() / 5.0, Math.min(e.getEnergy() / 4.0 + 0.2, power));
        Point2D.Double point = new Point2D.Double();
        double tmpx = enemy.getX();
        double tmpy = enemy.getY();
        this.oldHeading = head = e.getHeadingRadians();
        point.setLocation(tmpx, tmpy);
        long deltahittime = 0L;
        double currentHeading = e.getHeadingRadians();
        double currentVelocity = e.getVelocity();
        double currentTurn = currentHeading - previousHeading;
        if (currentTurn > Math.PI) {
            currentTurn -= Math.PI * 2;
        } else if (currentTurn < -Math.PI) {
            currentTurn += Math.PI * 2;
        }
        RCBot.historyTurn[RCBot.historyPointer] = currentTurn;
        RCBot.historyTurnAvg[RCBot.historyPointer] = this.averageTurn();
        RCBot.historyVelocity[RCBot.historyPointer] = currentVelocity;
        previousHeading = currentHeading;
        if (++historyPointer >= HISTORY_SIZE) {
            historyPointer = 0;
        }
        double frac = 1.0;
        do {
            if (historyPointer >= 1) {
                int pointer = historyPointer;
                frac = historyVelocity[pointer] == historyVelocity[pointer - 1] ? 1.0 : historyVelocity[pointer] - historyVelocity[pointer - 1];
            }
            deltahittime = (long)((double)deltahittime + 1.0);
            if (!this.fireField.contains(tmpx += Math.sin(head += historyTurnAvg[historyPointer]) * (e.getVelocity() / frac), tmpy += Math.cos(head) * (e.getVelocity() / frac))) {
                point.setLocation(this.warpPoint(tmpx, tmpy));
                double bspeed = point.distance(this.myPosition) / (double)deltahittime;
                power = Math.max(Math.min((20.0 - bspeed) / 3.0, 3.0), 0.1);
                break;
            }
            point.setLocation(tmpx, tmpy);
        } while ((long)((int)Math.round((point.distance(this.myPosition) - 18.0) / (20.0 - 3.0 * power))) > deltahittime);
        point.setLocation(this.warpPoint(tmpx, tmpy));
        if (power > 0.0 && this.getEnergy() > 0.1) {
            this.setFire(power);
        }
        if ((angle = Math.atan2(point.x - this.myPosition.getX(), point.y - this.myPosition.getY()) - this.getGunHeadingRadians()) > Math.PI) {
            angle -= Math.PI * 2;
        } else if (angle < -Math.PI) {
            angle += Math.PI * 2;
        }
        this.setTurnGunRightRadians(angle);
    }

    private final double averageTurn() {
        double sum = 0.0;
        int pos = historyPointer;
        int i = 0;
        while (i < HISTORY_AVERAGE) {
            sum += historyTurn[pos];
            if (--pos < 0) {
                pos = HISTORY_SIZE - 1;
            }
            ++i;
        }
        return sum;
    }

    public void doMeleeMovement() {
        double temprisk = 100.0;
        Point2D.Double testPoint = new Point2D.Double();
        Point2D.Double tempPoint = new Point2D.Double();
        this.myPosition.setLocation(this.getX(), this.getY());
        if (this.currentTarget != null) {
            double travel = Math.max(60.0, this.myPosition.distance(this.currentTarget) * 0.35);
            double goalrisk = this.calcRisk(this.myGoalPosition, this.getHeadingRadians());
            double angle = 0.0;
            while (angle < Math.PI * 2) {
                ((Point2D)testPoint).setLocation(this.myPosition.getX() + Math.sin(angle) * travel, this.myPosition.getY() + Math.cos(angle) * travel);
                if (this.playField.contains(testPoint)) {
                    double d;
                    double testrisk = this.calcRisk(testPoint, angle);
                    if (d < temprisk) {
                        tempPoint.setLocation(testPoint);
                        temprisk = testrisk;
                    }
                }
                angle += 0.08726646259971647;
            }
            if (temprisk < goalrisk * 0.9) {
                this.myGoalPosition.setLocation(tempPoint);
                goalrisk = temprisk;
            }
            angle = Utils.normalRelativeAngle((double)(Math.atan2(this.myPosition.getX() - this.myGoalPosition.getX(), this.myPosition.getY() - this.myGoalPosition.getY()) - this.getHeadingRadians()));
            this.setTurnRightRadians(Math.atan(Math.tan(angle)));
            this.setMaxVelocity(10.0 - 4.0 * Math.abs(this.getTurnRemainingRadians()));
            this.setAhead((angle == Math.atan(Math.tan(angle)) ? -1.0 : 1.0) * travel);
        }
    }

    public Point2D.Double warpPoint(double x, double y) {
        Point2D.Double pos = new Point2D.Double();
        pos.x = Math.min(this.fieldWidth - 17.0, Math.max(17.0, x));
        pos.y = Math.min(this.fieldHeight - 17.0, Math.max(17.0, y));
        return pos;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        EnemyInfo enemy = (EnemyInfo)this.enemies.get(e.getName());
        if (enemy != null) {
            enemy.lastHit = this.getTime();
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (this.enemies.remove(e.getName()) == this.currentTarget) {
            this.currentTarget = this.findNewTarget();
            this.setTurnRadarRight(Double.POSITIVE_INFINITY);
            this.radarScan = true;
        }
    }

    private final EnemyInfo findNewTarget() {
        EnemyInfo bestTarget = new EnemyInfo();
        Collection enemySet = this.enemies.values();
        Iterator it = enemySet.iterator();
        bestTarget.attrac = Double.POSITIVE_INFINITY;
        while (it.hasNext()) {
            EnemyInfo e = (EnemyInfo)it.next();
            if (e.teammate || !(e.attrac < bestTarget.attrac)) continue;
            bestTarget = e;
        }
        return bestTarget;
    }

    private final double calcRisk(Point2D point, double movang) {
        double totrisk = 0.0;
        Collection enemySet = this.enemies.values();
        Iterator it = enemySet.iterator();
        totrisk = (double)(10 * (this.getOthers() - 1)) / point.distanceSq(this.centerPoint);
        totrisk += 3.0 / point.distanceSq(0.0, 0.0);
        totrisk += 3.0 / point.distanceSq(this.fieldWidth, 0.0);
        totrisk += 3.0 / point.distanceSq(0.0, this.fieldHeight);
        totrisk += 3.0 / point.distanceSq(this.fieldWidth, this.fieldHeight);
        do {
            double botrisk;
            EnemyInfo e = (EnemyInfo)it.next();
            if (!e.teammate) {
                double botangle = Utils.normalRelativeAngle((double)(Math.atan2(e.getX() - point.getX(), e.getY() - point.getY()) - movang));
                botrisk = 100.0;
                if (e == this.currentTarget) {
                    botrisk += 40.0;
                }
                botrisk *= 1.0 + (1.0 - Math.abs(Math.sin(botangle)) + Math.abs(Math.cos(botangle))) / 2.0;
            } else {
                botrisk = 10.0;
            }
            totrisk += botrisk / point.distanceSq(e);
        } while (it.hasNext());
        return totrisk += Math.random() * 0.5 / point.distanceSq(this.myPosition);
    }

    public void onWin(WinEvent e) {
        this.out.println("Woo! I won!");
    }

    public void onDeath(DeathEvent e) {
    }
}

