/*
 * Decompiled with CFR 0.152.
 */
package morbid;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import morbid.BasicRandomMotionStrategy;
import morbid.BrokeredObject;
import morbid.EnemyFireDetectedEvent;
import morbid.IBulletObject;
import morbid.IEnemyBulletManager;
import morbid.IPotentialManager;
import morbid.IRobotController;
import morbid.IRobotPositionManager;
import morbid.Utils;
import robocode.Event;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;

class LMeleeMotionStrategy
extends BasicRandomMotionStrategy {
    private final int m_eventCutoffAge;
    private int m_stateTime;
    private int m_state;
    private int m_prevState = -1;
    private int m_corner;
    private int m_boundary;
    private final double[] m_maxPhiGap = new double[2];
    private final Set m_permanentForcePoints = new HashSet();
    private final List m_enemyFireEvents = new ArrayList();
    private final List m_linesOfFire = new ArrayList();
    private static final Class[] ACCEPTABLE_EVENTS = new Class[]{class$morbid$EnemyFireDetectedEvent == null ? (class$morbid$EnemyFireDetectedEvent = LMeleeMotionStrategy.class$("morbid.EnemyFireDetectedEvent")) : class$morbid$EnemyFireDetectedEvent};
    private static final int STRATEGY_LIFETIME = 10;
    private static final int CENTER = 0;
    private static final int BOUNDARY = 1;
    private static final int CORNER = 2;
    private static final double ENEMY_DISTANCE_FIRE_DETECTION_THRESHOLD = 300.0;
    private final double m_bulletScale;
    private final double m_enemyScale;
    private final double m_escapeScale;
    private final double m_timedBoundaryScale;
    private final double m_timedCornerScale;
    private final double m_obstacleScale;
    private final double m_perimeterScale;
    private final double m_centerScale;
    private static final boolean DO_MOTION_NOISE = true;
    private static final boolean DO_DIRECT_BULLET_FORCE_POINT = true;
    private static final boolean DEBUG_CENTER = false;
    private static final boolean DEBUG_STATE = false;
    private static final boolean DEBUG = false;
    static /* synthetic */ Class class$morbid$EnemyFireDetectedEvent;

    public LMeleeMotionStrategy(IRobotController controller) {
        super(controller);
        double diagonal = Utils.relativeDistance(0.0, 0.0, this.m_field_width, this.m_field_height);
        this.m_eventCutoffAge = (int)(diagonal / Utils.bulletPowerToVelocity(3.0));
        this.m_enemyScale = this.m_bulletScale = 1.0;
        this.m_obstacleScale = this.m_centerScale = 2.0 * this.m_bulletScale;
        this.m_perimeterScale = this.m_centerScale * 0.08 * 32.0 * this.m_size * this.m_size * this.m_size / ((diagonal - 4.0 * this.m_size) * (diagonal - 4.0 * this.m_size));
        this.m_escapeScale = 2.0 * this.m_centerScale;
        this.m_timedBoundaryScale = 10.0 * this.m_bulletScale;
        this.m_timedCornerScale = 10.0 * this.m_bulletScale;
    }

    public Class[] getAcceptableEventTypes() {
        return BrokeredObject.mergeTypeArrays(super.getAcceptableEventTypes(), ACCEPTABLE_EVENTS);
    }

    public void acceptEvent(Event event) {
        if (event instanceof EnemyFireDetectedEvent) {
            this.m_enemyFireEvents.add(event);
        } else {
            super.acceptEvent(event);
        }
    }

    protected void activate() {
        super.activate();
        this.m_controller.getMotionManager().setNoiseLevel(-1, Double.MAX_VALUE, 4, Utils.degreesToRadians(40.0));
        IPotentialManager potentialManager = this.m_controller.getPotentialManager();
        if (this.m_permanentForcePoints.isEmpty()) {
            this.m_permanentForcePoints.add(new IPotentialManager.PermanentForceLine3(this.m_perimeterScale, this.m_size, this.m_field_width / 2.0, 0.0, 0.0));
            this.m_permanentForcePoints.add(new IPotentialManager.PermanentForceLine3(this.m_perimeterScale, this.m_size, this.m_field_width / 2.0, this.m_field_height, Math.PI));
            this.m_permanentForcePoints.add(new IPotentialManager.PermanentForceLine3(this.m_perimeterScale, this.m_size, 0.0, this.m_field_height / 2.0, 1.5707963267948966));
            this.m_permanentForcePoints.add(new IPotentialManager.PermanentForceLine3(this.m_perimeterScale, this.m_size, this.m_field_width, this.m_field_height / 2.0, 4.71238898038469));
            this.m_permanentForcePoints.add(new IPotentialManager.PermanentForceLine3(this.m_perimeterScale, this.m_size, 0.0, 0.0, 0.7853981633974483));
            this.m_permanentForcePoints.add(new IPotentialManager.PermanentForceLine3(this.m_perimeterScale, this.m_size, this.m_field_width, this.m_field_height, 3.9269908169872414));
            this.m_permanentForcePoints.add(new IPotentialManager.PermanentForceLine3(this.m_perimeterScale, this.m_size, 0.0, this.m_field_height, 2.356194490192345));
            this.m_permanentForcePoints.add(new IPotentialManager.PermanentForceLine3(this.m_perimeterScale, this.m_size, this.m_field_width, 0.0, 5.497787143782138));
            this.m_permanentForcePoints.add(new IPotentialManager.PermanentForcePoint(Utils.getGID("CP"), this.m_centerScale, this.m_size, this.m_field_width / 2.0, this.m_field_height / 2.0));
        }
        Iterator i = this.m_permanentForcePoints.iterator();
        while (i.hasNext()) {
            potentialManager.addForcePoint((IPotentialManager.IForcePoint)i.next());
        }
    }

    protected void passivate() {
        this.m_controller.getMotionManager().setNoiseLevel(-1, Double.MAX_VALUE, -1, 0.0);
        IPotentialManager potentialManager = this.m_controller.getPotentialManager();
        Iterator i = this.m_permanentForcePoints.iterator();
        while (i.hasNext()) {
            potentialManager.removeForcePoint(((IPotentialManager.IForcePoint)i.next()).getID());
        }
        super.passivate();
    }

    protected double bid() {
        long activeTime = this.getActiveTime();
        long activeBid = this.isActive() && activeTime < 10L ? 10L - activeTime : 0L;
        return this.m_controller.getRobotPositionManager().getKnownAliveObjectCount() > 2 ? (double)(activeBid + (long)(2 * this.m_controller.getRobotPositionManager().getKnownAliveObjectCount())) : (double)(activeBid - 1L);
    }

    protected boolean handleObstacleEvents(double[] out) {
        if (!this.m_obstacleEvents.isEmpty()) {
            this.m_robotIDs.clear();
            this.m_collisionHeadings.clear();
            int e = this.m_obstacleEvents.size() - 1;
            while (e >= 0) {
                HitRobotEvent event;
                Event _event = (Event)this.m_obstacleEvents.get(e);
                if (_event instanceof HitRobotEvent) {
                    event = (HitRobotEvent)_event;
                    if (!this.m_robotIDs.contains(event.getName())) {
                        this.m_robotIDs.add(event.getName());
                        this.m_collisionHeadings.add(new Double(event.getBearingRadians()));
                    }
                } else if (_event instanceof HitWallEvent) {
                    event = (HitWallEvent)_event;
                    this.m_collisionHeadings.add(new Double(event.getBearingRadians()));
                }
                --e;
            }
            double netHeadingX = 0.0;
            double netHeadingY = 0.0;
            int h = 0;
            int hSize = this.m_collisionHeadings.size();
            while (h < hSize) {
                double heading = (Double)this.m_collisionHeadings.get(h) + this.m_robot.getHeadingRadians();
                netHeadingX += Math.sin(heading);
                netHeadingY += Math.cos(heading);
                ++h;
            }
            double netHeading = Utils.reversePhi(Utils.relativeHeading(0.0, 0.0, netHeadingX, netHeadingY));
            this.m_controller.getPotentialManager().addForcePoint(new IPotentialManager.TimedForceLine(this.m_controller, this.m_obstacleScale, this.m_size, this.m_robot.getX() + 10.0 * Math.sin(netHeading += 0.15 * (0.5 - this.m_random.nextDouble())), this.m_robot.getY() + 10.0 * Math.cos(netHeading), netHeading, 6L));
            out[0] = this.m_robot.getX() + this.m_size * Math.sin(netHeading);
            out[1] = this.m_robot.getY() + this.m_size * Math.cos(netHeading);
            this.clearEvents();
            return true;
        }
        return false;
    }

    protected void computeNextGoTo(double[] out) {
        IPotentialManager potentialManager = this.m_controller.getPotentialManager();
        IRobotPositionManager robotPositionManager = this.m_controller.getRobotPositionManager();
        long time = this.m_robot.getTime();
        IRobotPositionManager.ITrackedRobot[] enemies = robotPositionManager.getKnownAliveObjects();
        int e = 0;
        while (e < enemies.length) {
            if (potentialManager.getForcePoint(enemies[e].getID()) == null) {
                IPotentialManager.EnemyForcePoint enemyForcePoint = new IPotentialManager.EnemyForcePoint(this.m_controller, this.m_enemyScale, this.m_size, enemies[e]);
                this.m_permanentForcePoints.add(enemyForcePoint);
                potentialManager.addForcePoint(enemyForcePoint);
            }
            ++e;
        }
        if (!this.m_enemyFireEvents.isEmpty()) {
            IEnemyBulletManager enemyBulletManager = this.m_controller.getEnemyBulletManager();
            int e2 = this.m_enemyFireEvents.size() - 1;
            while (e2 >= 0) {
                EnemyFireDetectedEvent event = (EnemyFireDetectedEvent)((Object)this.m_enemyFireEvents.remove(e2));
                if (time - event.getTime() <= (long)this.m_eventCutoffAge) {
                    IBulletObject.IBullet bullet = event.getFireFact().getBullet();
                    double bulletScale = this.m_bulletScale * bullet.getPower() / 3.0;
                    potentialManager.addForcePoint(new IPotentialManager.EnemyBulletForceLine(this.m_controller, bulletScale, this.m_size, bullet));
                    double bulletHeading = Utils.relativeHeading(bullet.getXY(), this.m_robot.getX(), this.m_robot.getY());
                    IBulletObject.IBullet bullet2 = enemyBulletManager.addBullet(bullet.getSourceID(), this.m_robot.getName(), event.getFireFact().getFireTime(), bullet.getX(), bullet.getY(), bulletHeading, bullet.getPower(), null);
                    potentialManager.addForcePoint(new IPotentialManager.EnemyBulletForceLine(this.m_controller, bulletScale, this.m_size, bullet2));
                }
                --e2;
            }
        }
        double[] f = potentialManager.getTotalActiveForce(this.m_robot.getX(), this.m_robot.getY());
        double abs_f = Utils.relativeDistance(f, 0.0, 0.0);
        double x = this.m_robot.getX();
        double y = this.m_robot.getY();
        double gap = 4.0 * this.m_size;
        int period = 8;
        this.m_prevState = this.m_state;
        this.m_state = Utils.inTheCorner(x, y, gap, this.m_field_width, this.m_field_height) ? 2 : (Utils.onTheBoundary(x, y, gap, this.m_field_width, this.m_field_height) ? 1 : 0);
        this.m_stateTime = this.m_prevState != this.m_state ? 0 : ++this.m_stateTime;
        switch (this.m_state) {
            case 0: {
                if (robotPositionManager.getKnownAliveObjectCount() < 3) break;
                ArrayList<IRobotPositionManager.ITrackedRobot> closeEnemies = new ArrayList<IRobotPositionManager.ITrackedRobot>();
                int e3 = 0;
                while (e3 < enemies.length) {
                    if (Utils.relativeDistance(x, y, enemies[e3].getX(), enemies[e3].getY()) < 300.0) {
                        closeEnemies.add(enemies[e3]);
                    }
                    ++e3;
                }
                if (closeEnemies.size() <= 1) break;
                double[] headings = new double[closeEnemies.size()];
                int ce = 0;
                while (ce < headings.length) {
                    IRobotPositionManager.IUpdatedRobot cenemy = (IRobotPositionManager.IUpdatedRobot)closeEnemies.get(ce);
                    headings[ce] = Utils.relativeHeading(x, y, cenemy.getXY());
                    ++ce;
                }
                Utils.maxPhiGap(this.m_maxPhiGap, headings);
                double forceHeading = Utils.reversePhi(this.m_maxPhiGap[0]);
                potentialManager.addForcePoint(new IPotentialManager.TimedForceLine(this.m_controller, this.m_escapeScale, this.m_size, x - 10.0 * Math.sin(forceHeading), y - 10.0 * Math.cos(forceHeading), forceHeading, 10L));
                break;
            }
            case 1: {
                double py;
                double px;
                double r_to_corner_k_1;
                if (this.m_stateTime < 8) break;
                int boundary = Utils.closestBoundary(x, y, this.m_field_width, this.m_field_height);
                double shift = this.m_random.nextDouble() * this.m_size;
                double r_to_corner_k = Utils.cornerDistance(boundary, x, y, this.m_field_width, this.m_field_height);
                double direction = r_to_corner_k < (r_to_corner_k_1 = Utils.cornerDistance((boundary + 3) % 4, x, y, this.m_field_width, this.m_field_height)) ? 1.0 : -1.0;
                switch (boundary) {
                    default: {
                        px = x - shift;
                        py = -1.0;
                        break;
                    }
                    case 1: {
                        px = -1.0;
                        py = y + shift;
                        break;
                    }
                    case 2: {
                        px = x + shift;
                        py = this.m_field_height + 1.0;
                        break;
                    }
                    case 3: {
                        px = this.m_field_width + 1.0;
                        py = y - shift;
                    }
                }
                potentialManager.addForcePoint(new IPotentialManager.TimedForcePoint(this.m_controller, this.m_timedBoundaryScale, this.m_size, px, py, 8L));
                this.m_stateTime = 0;
                break;
            }
            case 2: {
                double py;
                double px;
                if (this.m_stateTime < 8) break;
                int corner = Utils.closestCorner(x, y, this.m_field_width, this.m_field_height);
                double shiftX = this.m_random.nextDouble() * gap;
                double shiftY = this.m_random.nextDouble() * gap;
                switch (corner) {
                    default: {
                        px = shiftX;
                        py = shiftY;
                        break;
                    }
                    case 1: {
                        px = shiftX;
                        py = this.m_field_height - shiftY;
                        break;
                    }
                    case 2: {
                        px = this.m_field_width - shiftX;
                        py = this.m_field_height - shiftY;
                        break;
                    }
                    case 3: {
                        px = this.m_field_width - shiftX;
                        py = shiftY;
                    }
                }
                potentialManager.addForcePoint(new IPotentialManager.TimedForcePoint(this.m_controller, this.m_timedCornerScale, this.m_size, px, py, 8L));
                this.m_stateTime = 0;
            }
        }
        if (abs_f / 1000000.0 < 1.0E-4) {
            super.computeNextGoTo(out);
        } else {
            double jump = 2.0 * this.m_size;
            out[0] = this.m_robot.getX() + f[0] * jump / abs_f;
            out[1] = this.m_robot.getY() + f[1] * jump / abs_f;
            super.avoidWalls(out);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

