/*
 * Decompiled with CFR 0.152.
 */
package morbid;

import morbid.IRobotController;
import morbid.IStatsManager;
import morbid.RobotController;
import morbid.StatsManager;
import morbid.Utils;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public final class MorbidPriest
extends AdvancedRobot {
    private static IStatsManager STATS_MANAGER = new StatsManager();
    private IRobotController m_controller;
    private static final boolean DEBUG = false;

    public void run() {
        while (true) {
            block4: {
                try {
                    this.exist();
                }
                catch (DebugStop stop) {
                    return;
                }
                catch (RuntimeException t) {
                    t.printStackTrace(((Robot)this).out);
                    if (!t.getClass().getName().startsWith("robocode")) break block4;
                    throw t;
                }
            }
            ((Robot)this).out.println("HARD RESET");
        }
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        this.m_controller.addEvent((Event)event);
    }

    public void onRobotDeath(RobotDeathEvent event) {
        this.m_controller.addEvent((Event)event);
    }

    public void onCustomEvent(CustomEvent event) {
        this.m_controller.addEvent((Event)event);
    }

    public void onWin(WinEvent event) {
        this.m_controller.broadcastEvent((Event)event);
    }

    public void onDeath(DeathEvent event) {
        this.m_controller.broadcastEvent((Event)event);
    }

    public void onHitByBullet(HitByBulletEvent event) {
        this.m_controller.addEvent((Event)event);
    }

    public void onBulletHit(BulletHitEvent event) {
        this.m_controller.addEvent((Event)event);
    }

    public void onHitRobot(HitRobotEvent event) {
        this.m_controller.addEvent((Event)event);
    }

    public void onHitWall(HitWallEvent event) {
        this.m_controller.addEvent((Event)event);
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
    }

    public String toString() {
        StringBuffer s = new StringBuffer(0);
        s.append('{');
        s.append(this.getName());
        s.append(": ");
        s.append(Utils.printDouble(this.getX()));
        s.append('/');
        s.append(Utils.printDouble(this.getY()));
        s.append(", size: ");
        s.append(Utils.printDouble(this.getWidth()));
        s.append('/');
        s.append(Utils.printDouble(this.getHeight()));
        s.append(", H ");
        s.append(Utils.printPhi(this.getHeadingRadians()));
        s.append(", V ");
        s.append(Utils.printDouble(this.getVelocity()));
        s.append(", E ");
        s.append(Utils.printDouble(this.getEnergy()));
        s.append('}');
        return s.toString();
    }

    private void exist() {
        RuntimeException failure = null;
        int round = this.getRoundNum();
        this.m_controller = new RobotController(this, STATS_MANAGER);
        this.m_controller.setup();
        STATS_MANAGER.roundStart(this.m_controller, round);
        try {
            try {
                while (true) {
                    this.m_controller.update();
                    this.m_controller.act();
                }
            }
            catch (RuntimeException rethrow) {
                rethrow.printStackTrace(((Robot)this).out);
                failure = rethrow;
                Object var5_4 = null;
                try {
                    STATS_MANAGER.roundEnd();
                    if (round == this.getNumRounds()) {
                        STATS_MANAGER = new StatsManager();
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                if (failure != null) {
                    throw failure;
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                STATS_MANAGER.roundEnd();
                if (round == this.getNumRounds()) {
                    STATS_MANAGER = new StatsManager();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            if (failure != null) {
                throw failure;
            }
            throw throwable;
        }
    }

    private class DebugStop
    extends RuntimeException {
        DebugStop() {
            ((Robot)MorbidPriest.this).out.println("DEBUG STOP");
        }
    }
}

